/*
 * Decompiled with CFR 0.152.
 */
package org.drools.core.reteoo;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.reflect.Field;
import org.drools.core.common.InternalWorkingMemory;
import org.drools.core.impl.InternalKnowledgeBase;
import org.drools.core.reteoo.AlphaNode;
import org.drools.core.reteoo.BetaMemory;
import org.drools.core.reteoo.JoinNode;
import org.drools.core.reteoo.LeftInputAdapterNode;
import org.drools.core.reteoo.LeftTupleSink;
import org.drools.core.reteoo.LeftTupleSinkPropagator;
import org.drools.core.reteoo.LeftTupleSource;
import org.drools.core.reteoo.NotNode;
import org.drools.core.reteoo.ObjectSink;
import org.drools.core.reteoo.ObjectSinkPropagator;
import org.drools.core.reteoo.ObjectSource;
import org.drools.core.reteoo.ObjectTypeNode;
import org.drools.core.reteoo.Rete;
import org.drools.core.reteoo.RuleTerminalNode;
import org.drools.core.reteoo.TupleMemory;
import org.drools.core.spi.Tuple;
import org.drools.core.util.AbstractHashTable;
import org.drools.core.util.Entry;
import org.drools.core.util.FastIterator;
import org.drools.core.util.LinkedList;
import org.drools.core.util.ReflectiveVisitor;
import org.drools.core.util.index.TupleIndexHashTable;
import org.drools.core.util.index.TupleList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemoryVisitor
extends ReflectiveVisitor
implements Externalizable {
    protected static final transient Logger logger = LoggerFactory.getLogger(MemoryVisitor.class);
    private InternalWorkingMemory workingMemory;
    private int indent = 0;

    public MemoryVisitor() {
    }

    public MemoryVisitor(InternalWorkingMemory workingMemory) {
        this.workingMemory = workingMemory;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.workingMemory = (InternalWorkingMemory)in.readObject();
        this.indent = in.readInt();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.workingMemory);
        out.writeInt(this.indent);
    }

    public void visitReteooRuleBase(InternalKnowledgeBase kBase) {
        this.visit(kBase.getRete());
    }

    public void visitRete(Rete rete) {
        for (ObjectTypeNode node : rete.getObjectTypeNodes()) {
            this.visit(node);
        }
    }

    public void visitObjectTypeNode(ObjectTypeNode node) {
        logger.info(this.indent() + node);
        ++this.indent;
        try {
            ObjectSink[] sinks;
            Field field = ObjectSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            ObjectSinkPropagator sink = (ObjectSinkPropagator)field.get(node);
            for (ObjectSink sink1 : sinks = sink.getSinks()) {
                this.visit(sink1);
            }
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        --this.indent;
    }

    public void visitAlphaNode(AlphaNode node) {
        logger.info(this.indent() + node);
        ++this.indent;
        try {
            ObjectSink[] sinks;
            Field field = ObjectSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            ObjectSinkPropagator sink = (ObjectSinkPropagator)field.get(node);
            for (ObjectSink sink1 : sinks = sink.getSinks()) {
                this.visit(sink1);
            }
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        --this.indent;
    }

    public void visitLeftInputAdapterNode(LeftInputAdapterNode node) {
        logger.info(this.indent() + node);
        ++this.indent;
        try {
            LeftTupleSink[] sinks;
            Field field = LeftTupleSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            LeftTupleSinkPropagator sink = (LeftTupleSinkPropagator)field.get(node);
            for (LeftTupleSink sink1 : sinks = sink.getSinks()) {
                this.visit(sink1);
            }
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        --this.indent;
    }

    public void visitJoinNode(JoinNode node) {
        logger.info(this.indent() + node);
        try {
            BetaMemory memory = (BetaMemory)this.workingMemory.getNodeMemory(node);
            this.checkObjectHashTable(memory.getRightTupleMemory());
            this.checkLeftTupleMemory(memory.getLeftTupleMemory());
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        ++this.indent;
        try {
            LeftTupleSink[] sinks;
            Field field = LeftTupleSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            LeftTupleSinkPropagator sink = (LeftTupleSinkPropagator)field.get(node);
            for (LeftTupleSink sink1 : sinks = sink.getSinks()) {
                this.visit(sink1);
            }
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        --this.indent;
    }

    public void visitNotNode(NotNode node) {
        logger.info(this.indent() + node);
        try {
            BetaMemory memory = (BetaMemory)this.workingMemory.getNodeMemory(node);
            this.checkObjectHashTable(memory.getRightTupleMemory());
            this.checkLeftTupleMemory(memory.getLeftTupleMemory());
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        ++this.indent;
        try {
            LeftTupleSink[] sinks;
            Field field = LeftTupleSource.class.getDeclaredField("sink");
            field.setAccessible(true);
            LeftTupleSinkPropagator sink = (LeftTupleSinkPropagator)field.get(node);
            for (LeftTupleSink sink1 : sinks = sink.getSinks()) {
                this.visit(sink1);
            }
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        --this.indent;
    }

    public void visitRuleTerminalNode(RuleTerminalNode node) {
        logger.info(this.indent() + node);
    }

    private void checkObjectHashTable(TupleMemory memory) {
        if (memory instanceof TupleList) {
            this.checkRightTupleList((TupleList)memory);
        } else if (memory instanceof TupleIndexHashTable) {
            this.checkRightTupleIndexHashTable((TupleIndexHashTable)memory);
        } else {
            throw new RuntimeException(memory.getClass() + " should not be here");
        }
    }

    private void checkRightTupleList(TupleList memory) {
        int count = 0;
        FastIterator rightIt = memory.fastIterator();
        Tuple rightTuple = memory.getFirst();
        while (rightTuple != null) {
            ++count;
            rightTuple = (Tuple)rightIt.next(rightTuple);
        }
        logger.info(this.indent() + "FactHashTable: " + memory.size() + ":" + count);
        if (memory.size() != count) {
            logger.info(this.indent() + "error");
        }
    }

    private void checkRightTupleIndexHashTable(TupleIndexHashTable memory) {
        Entry<TupleList>[] entries = memory.getTable();
        int factCount = 0;
        int bucketCount = 0;
        FastIterator it = LinkedList.fastIterator;
        for (Entry<TupleList> entry1 : entries) {
            if (entry1 == null) continue;
            TupleList rightTupleList = (TupleList)entry1;
            while (rightTupleList != null) {
                if (rightTupleList.getFirst() != null) {
                    Entry<Tuple> entry = rightTupleList.getFirst();
                    while (entry != null) {
                        entry = it.next(entry);
                        ++factCount;
                    }
                } else {
                    logger.info("error : fieldIndexHashTable cannot have empty FieldIndexEntry objects");
                }
                rightTupleList = rightTupleList.getNext();
                ++bucketCount;
            }
        }
        try {
            Field field = AbstractHashTable.class.getDeclaredField("size");
            field.setAccessible(true);
            logger.info(this.indent() + "FieldIndexBuckets: " + field.get(memory) + ":" + bucketCount);
            if ((Integer)field.get(memory) != bucketCount) {
                logger.info(this.indent() + "error");
            }
        }
        catch (Exception e) {
            logger.error("Exception", (Throwable)e);
        }
        logger.info(this.indent() + "FieldIndexFacts: " + memory.size() + ":" + factCount);
        if (memory.size() != factCount) {
            logger.info(this.indent() + "error");
        }
    }

    private void checkLeftTupleMemory(TupleMemory memory) {
    }

    private String indent() {
        StringBuilder buffer = new StringBuilder();
        for (int i = 0; i < this.indent; ++i) {
            buffer.append("  ");
        }
        return buffer.toString();
    }
}

