/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.cubeoutput;

import java.util.List;
import java.util.Map;
import org.apache.commons.vfs2.FileObject;
import org.apache.hop.core.CheckResult;
import org.apache.hop.core.ICheckResult;
import org.apache.hop.core.ICheckResultSource;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.core.vfs.HopVfs;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.HopMetadataWrapper;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.cubeoutput.CubeOutput;
import org.apache.hop.pipeline.transforms.cubeoutput.CubeOutputData;
import org.apache.hop.resource.IResourceNaming;
import org.apache.hop.resource.ResourceDefinition;

@Transform(id="CubeOutput", image="cubeoutput.svg", name="i18n::CubeOutput.Name", description="i18n::CubeOutput.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Output", keywords={"i18n::CubeOutputMeta.keyword"}, documentationUrl="/pipeline/transforms/serialize-to-file.html")
@HopMetadataWrapper(tag="file")
public class CubeOutputMeta
extends BaseTransformMeta<CubeOutput, CubeOutputData> {
    private static final Class<?> PKG = CubeOutputMeta.class;
    @HopMetadataProperty(key="name")
    private String filename;
    @HopMetadataProperty(key="filename_create_parent_folders")
    private boolean filenameCreatingParentFolders;
    @HopMetadataProperty(key="add_to_result_filenames")
    private boolean addToResultFilenames;
    @HopMetadataProperty(key="do_not_open_newfile_init")
    private boolean doNotOpenNewFileInit;

    public CubeOutputMeta() {
    }

    public CubeOutputMeta(CubeOutputMeta m) {
        this.filename = m.filename;
        this.filenameCreatingParentFolders = m.filenameCreatingParentFolders;
        this.addToResultFilenames = m.addToResultFilenames;
        this.doNotOpenNewFileInit = m.doNotOpenNewFileInit;
    }

    public CubeOutputMeta clone() {
        return new CubeOutputMeta(this);
    }

    public void setDefault() {
        this.addToResultFilenames = false;
        this.doNotOpenNewFileInit = false;
    }

    public void check(List<ICheckResult> remarks, PipelineMeta pipelineMeta, TransformMeta transformMeta, IRowMeta prev, String[] input, String[] output, IRowMeta info, IVariables variables, IHopMetadataProvider metadataProvider) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"CubeOutputMeta.CheckResult.ReceivingFields", (String[])new String[]{String.valueOf(prev.size())}), (ICheckResultSource)transformMeta);
            remarks.add((ICheckResult)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"CubeOutputMeta.CheckResult.FileSpecificationsNotChecked", (String[])new String[0]), (ICheckResultSource)transformMeta);
        remarks.add((ICheckResult)cr);
    }

    public String exportResources(IVariables variables, Map<String, ResourceDefinition> definitions, IResourceNaming iResourceNaming, IHopMetadataProvider metadataProvider) throws HopException {
        try {
            FileObject fileObject = HopVfs.getFileObject((String)variables.resolve(this.filename));
            if (fileObject.exists()) {
                this.filename = iResourceNaming.nameResource(fileObject, variables, true);
                return this.filename;
            }
            return null;
        }
        catch (Exception e) {
            throw new HopException((Throwable)e);
        }
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public boolean isFilenameCreatingParentFolders() {
        return this.filenameCreatingParentFolders;
    }

    public void setFilenameCreatingParentFolders(boolean filenameCreatingParentFolders) {
        this.filenameCreatingParentFolders = filenameCreatingParentFolders;
    }

    public boolean isAddToResultFilenames() {
        return this.addToResultFilenames;
    }

    public void setAddToResultFilenames(boolean addToResultFilenames) {
        this.addToResultFilenames = addToResultFilenames;
    }

    public boolean isDoNotOpenNewFileInit() {
        return this.doNotOpenNewFileInit;
    }

    public void setDoNotOpenNewFileInit(boolean doNotOpenNewFileInit) {
        this.doNotOpenNewFileInit = doNotOpenNewFileInit;
    }
}

