/*
 * Decompiled with CFR 0.152.
 */
package com.drew.imaging.quicktime;

import com.drew.imaging.FileType;
import com.drew.imaging.TypeChecker;
import java.util.HashMap;

public class QuickTimeTypeChecker
implements TypeChecker {
    private static final HashMap<String, FileType> _ftypMap = new HashMap();

    @Override
    public int getByteCount() {
        return 12;
    }

    @Override
    public FileType checkType(byte[] bytes) {
        if (bytes[4] == 102 && bytes[5] == 116 && bytes[6] == 121 && bytes[7] == 112) {
            String fourCC = new String(bytes, 8, 4);
            FileType t = _ftypMap.get(fourCC);
            if (t != null) {
                return t;
            }
            return FileType.QuickTime;
        }
        return FileType.Unknown;
    }

    static {
        _ftypMap.put("moov", FileType.QuickTime);
        _ftypMap.put("wide", FileType.QuickTime);
        _ftypMap.put("mdat", FileType.QuickTime);
        _ftypMap.put("free", FileType.QuickTime);
        _ftypMap.put("qt  ", FileType.QuickTime);
        _ftypMap.put("3g2a", FileType.QuickTime);
        _ftypMap.put("3gp5", FileType.Mp4);
        _ftypMap.put("avc1", FileType.Mp4);
        _ftypMap.put("iso2", FileType.Mp4);
        _ftypMap.put("isom", FileType.Mp4);
        _ftypMap.put("M4A ", FileType.Mp4);
        _ftypMap.put("M4B ", FileType.Mp4);
        _ftypMap.put("M4P ", FileType.Mp4);
        _ftypMap.put("M4V ", FileType.Mp4);
        _ftypMap.put("M4VH", FileType.Mp4);
        _ftypMap.put("M4VP", FileType.Mp4);
        _ftypMap.put("mmp4", FileType.Mp4);
        _ftypMap.put("mp41", FileType.Mp4);
        _ftypMap.put("mp42", FileType.Mp4);
        _ftypMap.put("mp71", FileType.Mp4);
        _ftypMap.put("MSNV", FileType.Mp4);
        _ftypMap.put("NDAS", FileType.Mp4);
        _ftypMap.put("NDSC", FileType.Mp4);
        _ftypMap.put("NDSH", FileType.Mp4);
        _ftypMap.put("NDSM", FileType.Mp4);
        _ftypMap.put("NDSP", FileType.Mp4);
        _ftypMap.put("NDSS", FileType.Mp4);
        _ftypMap.put("NDXC", FileType.Mp4);
        _ftypMap.put("NDXH", FileType.Mp4);
        _ftypMap.put("NDXM", FileType.Mp4);
        _ftypMap.put("NDXP", FileType.Mp4);
        _ftypMap.put("NDXS", FileType.Mp4);
        _ftypMap.put("nvr1", FileType.Mp4);
        _ftypMap.put("mif1", FileType.Heif);
        _ftypMap.put("msf1", FileType.Heif);
        _ftypMap.put("heic", FileType.Heif);
        _ftypMap.put("heix", FileType.Heif);
        _ftypMap.put("hevc", FileType.Heif);
        _ftypMap.put("hevx", FileType.Heif);
        _ftypMap.put("crx ", FileType.Crx);
    }
}

