/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.transport;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableMap;
import io.netty.handler.ssl.SslHandler;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.cassandra.auth.AuthenticatedUser;
import org.apache.cassandra.service.ClientState;
import org.apache.cassandra.transport.ConnectionStage;
import org.apache.cassandra.transport.ServerConnection;

public final class ConnectedClient {
    public static final String ADDRESS = "address";
    public static final String USER = "user";
    public static final String VERSION = "version";
    public static final String CLIENT_OPTIONS = "clientOptions";
    public static final String DRIVER_NAME = "driverName";
    public static final String DRIVER_VERSION = "driverVersion";
    public static final String REQUESTS = "requests";
    public static final String KEYSPACE = "keyspace";
    public static final String SSL = "ssl";
    public static final String CIPHER = "cipher";
    public static final String PROTOCOL = "protocol";
    private static final String UNDEFINED = "undefined";
    private final ServerConnection connection;

    ConnectedClient(ServerConnection connection) {
        this.connection = connection;
    }

    public ConnectionStage stage() {
        return this.connection.stage();
    }

    public InetSocketAddress remoteAddress() {
        return this.state().getRemoteAddress();
    }

    public Optional<String> username() {
        AuthenticatedUser user = this.state().getUser();
        return null != user ? Optional.of(user.getName()) : Optional.empty();
    }

    public int protocolVersion() {
        return this.connection.getVersion().asInt();
    }

    public Optional<String> driverName() {
        return this.state().getDriverName();
    }

    public Optional<String> driverVersion() {
        return this.state().getDriverVersion();
    }

    public Optional<Map<String, String>> clientOptions() {
        return this.state().getClientOptions();
    }

    public long requestCount() {
        return this.connection.requests.getCount();
    }

    public Optional<String> keyspace() {
        return Optional.ofNullable(this.state().getRawKeyspace());
    }

    public boolean sslEnabled() {
        return null != this.sslHandler();
    }

    public Optional<String> sslCipherSuite() {
        SslHandler sslHandler = this.sslHandler();
        return null != sslHandler ? Optional.of(sslHandler.engine().getSession().getCipherSuite()) : Optional.empty();
    }

    public Optional<String> sslProtocol() {
        SslHandler sslHandler = this.sslHandler();
        return null != sslHandler ? Optional.of(sslHandler.engine().getSession().getProtocol()) : Optional.empty();
    }

    private ClientState state() {
        return this.connection.getClientState();
    }

    private SslHandler sslHandler() {
        return (SslHandler)this.connection.channel().pipeline().get(SslHandler.class);
    }

    public Map<String, String> asMap() {
        return ImmutableMap.builder().put((Object)ADDRESS, (Object)this.remoteAddress().toString()).put((Object)USER, (Object)this.username().orElse(UNDEFINED)).put((Object)VERSION, (Object)String.valueOf(this.protocolVersion())).put((Object)CLIENT_OPTIONS, (Object)Joiner.on((String)", ").withKeyValueSeparator("=").join(this.clientOptions().orElse(Collections.emptyMap()))).put((Object)DRIVER_NAME, (Object)this.driverName().orElse(UNDEFINED)).put((Object)DRIVER_VERSION, (Object)this.driverVersion().orElse(UNDEFINED)).put((Object)REQUESTS, (Object)String.valueOf(this.requestCount())).put((Object)KEYSPACE, (Object)this.keyspace().orElse("")).put((Object)SSL, (Object)Boolean.toString(this.sslEnabled())).put((Object)CIPHER, (Object)this.sslCipherSuite().orElse(UNDEFINED)).put((Object)PROTOCOL, (Object)this.sslProtocol().orElse(UNDEFINED)).build();
    }
}

