/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.db.streaming;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.compress.CompressionMetadata;
import org.apache.cassandra.io.sstable.format.SSTableReader;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.schema.CompressionParams;

public abstract class CompressionInfo {
    public static final IVersionedSerializer<CompressionInfo> serializer = new CompressionInfoSerializer();

    public abstract CompressionParams parameters();

    public abstract CompressionMetadata.Chunk[] chunks();

    public long getTotalSize() {
        long size = 0L;
        for (CompressionMetadata.Chunk chunk : this.chunks()) {
            size += (long)(chunk.length + 4);
        }
        return size;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CompressionInfo)) {
            return false;
        }
        CompressionInfo that = (CompressionInfo)o;
        return Objects.equals(this.parameters(), that.parameters()) && Arrays.equals(this.chunks(), that.chunks());
    }

    public int hashCode() {
        return Objects.hash(this.parameters(), this.chunks());
    }

    public static CompressionInfo newInstance(final CompressionMetadata.Chunk[] chunks, final CompressionParams parameters) {
        assert (chunks != null && parameters != null);
        return new CompressionInfo(){

            @Override
            public CompressionMetadata.Chunk[] chunks() {
                return chunks;
            }

            @Override
            public CompressionParams parameters() {
                return parameters;
            }
        };
    }

    static CompressionInfo newLazyInstance(final CompressionMetadata metadata, final List<SSTableReader.PartitionPositionBounds> sections) {
        if (metadata == null) {
            return null;
        }
        return new CompressionInfo(){
            private volatile CompressionMetadata.Chunk[] chunks;

            @Override
            public synchronized CompressionMetadata.Chunk[] chunks() {
                if (this.chunks == null) {
                    this.chunks = metadata.getChunksForSections(sections);
                }
                return this.chunks;
            }

            @Override
            public CompressionParams parameters() {
                return metadata.parameters;
            }

            @Override
            public long getTotalSize() {
                if (this.chunks == null) {
                    return metadata.getTotalSizeForSections(sections);
                }
                return super.getTotalSize();
            }
        };
    }

    static class CompressionInfoSerializer
    implements IVersionedSerializer<CompressionInfo> {
        CompressionInfoSerializer() {
        }

        @Override
        public void serialize(CompressionInfo info, DataOutputPlus out, int version) throws IOException {
            if (info == null) {
                out.writeInt(-1);
                return;
            }
            CompressionMetadata.Chunk[] chunks = info.chunks();
            int chunkCount = chunks.length;
            out.writeInt(chunkCount);
            for (int i = 0; i < chunkCount; ++i) {
                CompressionMetadata.Chunk.serializer.serialize(chunks[i], out, version);
            }
            CompressionParams.serializer.serialize(info.parameters(), out, version);
        }

        @Override
        public CompressionInfo deserialize(DataInputPlus in, int version) throws IOException {
            int chunkCount = in.readInt();
            if (chunkCount < 0) {
                return null;
            }
            CompressionMetadata.Chunk[] chunks = new CompressionMetadata.Chunk[chunkCount];
            for (int i = 0; i < chunkCount; ++i) {
                chunks[i] = (CompressionMetadata.Chunk)CompressionMetadata.Chunk.serializer.deserialize(in, version);
            }
            CompressionParams parameters = (CompressionParams)CompressionParams.serializer.deserialize(in, version);
            return CompressionInfo.newInstance(chunks, parameters);
        }

        @Override
        public long serializedSize(CompressionInfo info, int version) {
            if (info == null) {
                return TypeSizes.sizeof(-1);
            }
            CompressionMetadata.Chunk[] chunks = info.chunks();
            int chunkCount = chunks.length;
            long size = TypeSizes.sizeof(chunkCount);
            for (int i = 0; i < chunkCount; ++i) {
                size += CompressionMetadata.Chunk.serializer.serializedSize(chunks[i], version);
            }
            return size += CompressionParams.serializer.serializedSize(info.parameters(), version);
        }
    }
}

