/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.data;

import com.ibm.as400.data.DocNodeDescriptor;
import com.ibm.as400.data.PcmlData;
import com.ibm.as400.data.PcmlDocNode;

class DataDescriptor
extends DocNodeDescriptor {
    public DataDescriptor(PcmlDocNode node) {
        super(node);
    }

    @Override
    public String[] getAttributeList() {
        return ((PcmlData)this.getDocNode()).getAttributeList();
    }

    @Override
    public String getAttributeValue(String attr) {
        if (attr != null) {
            if (attr.equals("name")) {
                String name = this.getDocNode().getName();
                if (name.equals("")) {
                    return null;
                }
                return name;
            }
            if (attr.equals("usage")) {
                switch (this.getDocNode().getUsage()) {
                    case 2: {
                        return "input";
                    }
                    case 4: {
                        return "inputoutput";
                    }
                    case 3: {
                        return "output";
                    }
                    case 1: {
                        return "inherit";
                    }
                }
            } else {
                if (attr.equals("count")) {
                    String countId = ((PcmlData)this.getDocNode()).getUnqualifiedCountId();
                    if (countId != null) {
                        return countId;
                    }
                    int count = ((PcmlData)this.getDocNode()).getCount();
                    if (count < 1) {
                        return null;
                    }
                    return Integer.toString(count);
                }
                if (attr.equals("minvrm")) {
                    return ((PcmlData)this.getDocNode()).getMinvrmString();
                }
                if (attr.equals("maxvrm")) {
                    return ((PcmlData)this.getDocNode()).getMaxvrmString();
                }
                if (attr.equals("offset")) {
                    String offsetId = ((PcmlData)this.getDocNode()).getUnqualifiedOffsetId();
                    if (offsetId != null) {
                        return offsetId;
                    }
                    int offset = ((PcmlData)this.getDocNode()).getOffset();
                    if (offset < 1) {
                        return null;
                    }
                    return Integer.toString(offset);
                }
                if (attr.equals("offsetfrom")) {
                    String offsetfromId = ((PcmlData)this.getDocNode()).getUnqualifiedOffsetfromId();
                    if (offsetfromId != null) {
                        return offsetfromId;
                    }
                    int offsetfrom = ((PcmlData)this.getDocNode()).getOffsetfrom();
                    if (offsetfrom < 0) {
                        return null;
                    }
                    return Integer.toString(offsetfrom);
                }
                if (attr.equals("outputsize")) {
                    String outputsizeId = ((PcmlData)this.getDocNode()).getUnqualifiedOutputsizeId();
                    if (outputsizeId != null) {
                        return outputsizeId;
                    }
                    int outputsize = ((PcmlData)this.getDocNode()).getOutputsize();
                    if (outputsize < 1) {
                        return null;
                    }
                    return Integer.toString(outputsize);
                }
                if (attr.equals("type")) {
                    switch (((PcmlData)this.getDocNode()).getDataType()) {
                        case 1: {
                            return "char";
                        }
                        case 2: {
                            return "int";
                        }
                        case 3: {
                            return "packed";
                        }
                        case 4: {
                            return "zoned";
                        }
                        case 5: {
                            return "float";
                        }
                        case 6: {
                            return "byte";
                        }
                        case 7: {
                            return "struct";
                        }
                        case 8: {
                            return "date";
                        }
                        case 9: {
                            return "time";
                        }
                        case 10: {
                            return "timestamp";
                        }
                    }
                } else {
                    if (attr.equals("length")) {
                        String lengthId = ((PcmlData)this.getDocNode()).getUnqualifiedLengthId();
                        if (lengthId != null) {
                            return lengthId;
                        }
                        if (((PcmlData)this.getDocNode()).isLengthSpecified()) {
                            return Integer.toString(((PcmlData)this.getDocNode()).getLength());
                        }
                        return null;
                    }
                    if (attr.equals("precision")) {
                        int precision = ((PcmlData)this.getDocNode()).getPrecision();
                        if (precision < 1) {
                            return null;
                        }
                        return Integer.toString(precision);
                    }
                    if (attr.equals("ccsid")) {
                        String ccsidId = ((PcmlData)this.getDocNode()).getUnqualifiedCcsidId();
                        if (ccsidId != null) {
                            return ccsidId;
                        }
                        int ccsid = ((PcmlData)this.getDocNode()).getCcsid();
                        if (ccsid < 1) {
                            return null;
                        }
                        return Integer.toString(ccsid);
                    }
                    if (attr.equals("init")) {
                        return ((PcmlData)this.getDocNode()).getInit();
                    }
                    if (attr.equals("struct")) {
                        return ((PcmlData)this.getDocNode()).getStruct();
                    }
                    if (attr.equals("passby")) {
                        if (((PcmlData)this.getDocNode()).getPassby() == 1) {
                            return "value";
                        }
                        return "reference";
                    }
                    if (attr.equals("bidistringtype")) {
                        return ((PcmlData)this.getDocNode()).getBidistringtypeStr();
                    }
                    if (attr.equals("trim")) {
                        return ((PcmlData)this.getDocNode()).getTrim();
                    }
                    if (attr.equals("chartype")) {
                        return ((PcmlData)this.getDocNode()).getCharType();
                    }
                    if (attr.equals("dateformat")) {
                        return ((PcmlData)this.getDocNode()).getDateFormat();
                    }
                    if (attr.equals("timeformat")) {
                        return ((PcmlData)this.getDocNode()).getTimeFormat();
                    }
                    if (attr.equals("dateseparator")) {
                        return ((PcmlData)this.getDocNode()).getDateSeparator();
                    }
                    if (attr.equals("timeseparator")) {
                        return ((PcmlData)this.getDocNode()).getTimeSeparator();
                    }
                    return null;
                }
            }
        }
        return null;
    }
}

