/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.neo4j.transforms.cypherbuilder.operation;

public enum OperationType {
    MATCH("MATCH", "Match node"),
    MERGE("MERGE", "Merge node"),
    CREATE("CREATE", "Create node"),
    DELETE("DELETE", "Delete node"),
    SET("SET", "Set values"),
    RETURN("RETURN", "Return values"),
    ORDER_BY("ORDER BY", "Order by"),
    EDGE_MATCH("MATCH", "Match relationship"),
    EDGE_MERGE("MERGE", "Merge relationship"),
    EDGE_CREATE("CREATE", "Create relationship");

    private final String keyWord;
    private final String description;

    private OperationType(String keyWord, String description) {
        this.keyWord = keyWord;
        this.description = description;
    }

    public static String[] getOperationDescriptions() {
        String[] descriptions = new String[OperationType.values().length];
        for (int i = 0; i < OperationType.values().length; ++i) {
            descriptions[i] = OperationType.values()[i].getDescription();
        }
        return descriptions;
    }

    public static OperationType getOperationByDescription(String description) {
        for (OperationType operationType : OperationType.values()) {
            if (!operationType.description.equalsIgnoreCase(description)) continue;
            return operationType;
        }
        return null;
    }

    public String keyWord() {
        return this.keyWord;
    }

    public String getDescription() {
        return this.description;
    }
}

