/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.aad.adal4j;

import com.microsoft.aad.adal4j.StringHelper;
import com.nimbusds.jwt.JWTClaimsSet;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Objects;

public class UserInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    String uniqueId;
    String displayableId;
    String givenName;
    String familyName;
    String identityProvider;
    String passwordChangeUrl;
    Date passwordExpiresOn;
    String tenantId;

    private UserInfo() {
    }

    public String getDisplayableId() {
        return this.displayableId;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getGivenName() {
        return this.givenName;
    }

    public String getFamilyName() {
        return this.familyName;
    }

    public String getIdentityProvider() {
        return this.identityProvider;
    }

    public String getPasswordChangeUrl() {
        return this.passwordChangeUrl;
    }

    public Date getPasswordExpiresOn() {
        if (this.passwordExpiresOn != null) {
            return (Date)this.passwordExpiresOn.clone();
        }
        return null;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    static UserInfo createFromIdTokenClaims(JWTClaimsSet claims) throws ParseException {
        int claimExpiry;
        if (claims == null || claims.getClaims().size() == 0) {
            return null;
        }
        String uniqueId = null;
        String displayableId = null;
        if (!StringHelper.isBlank(claims.getStringClaim("oid"))) {
            uniqueId = claims.getStringClaim("oid");
        } else if (!StringHelper.isBlank(claims.getStringClaim("sub"))) {
            uniqueId = claims.getStringClaim("sub");
        }
        if (!StringHelper.isBlank(claims.getStringClaim("upn"))) {
            displayableId = claims.getStringClaim("upn");
        } else if (!StringHelper.isBlank(claims.getStringClaim("email"))) {
            displayableId = claims.getStringClaim("email");
        }
        UserInfo userInfo = new UserInfo();
        userInfo.uniqueId = uniqueId;
        userInfo.displayableId = displayableId;
        userInfo.familyName = claims.getStringClaim("family_name");
        userInfo.givenName = claims.getStringClaim("given_name");
        userInfo.identityProvider = claims.getStringClaim("idp");
        userInfo.tenantId = claims.getStringClaim("tid");
        if (!StringHelper.isBlank(claims.getStringClaim("pwd_url"))) {
            userInfo.passwordChangeUrl = claims.getStringClaim("pwd_url");
        }
        if (claims.getClaim("pwd_exp") != null && (claimExpiry = Integer.parseInt((String)claims.getClaim("pwd_exp"))) > 0) {
            GregorianCalendar expires = new GregorianCalendar();
            ((Calendar)expires).add(13, claimExpiry);
            userInfo.passwordExpiresOn = expires.getTime();
        }
        return userInfo;
    }

    public int hashCode() {
        int hash = 5;
        hash = 37 * hash + Objects.hashCode(this.uniqueId);
        hash = 37 * hash + Objects.hashCode(this.displayableId);
        hash = 37 * hash + Objects.hashCode(this.givenName);
        hash = 37 * hash + Objects.hashCode(this.familyName);
        hash = 37 * hash + Objects.hashCode(this.identityProvider);
        hash = 37 * hash + Objects.hashCode(this.passwordChangeUrl);
        hash = 37 * hash + Objects.hashCode(this.passwordExpiresOn);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        UserInfo other = (UserInfo)obj;
        if (!Objects.equals(this.uniqueId, other.uniqueId)) {
            return false;
        }
        if (!Objects.equals(this.displayableId, other.displayableId)) {
            return false;
        }
        if (!Objects.equals(this.givenName, other.givenName)) {
            return false;
        }
        if (!Objects.equals(this.familyName, other.familyName)) {
            return false;
        }
        if (!Objects.equals(this.identityProvider, other.identityProvider)) {
            return false;
        }
        if (!Objects.equals(this.passwordChangeUrl, other.passwordChangeUrl)) {
            return false;
        }
        return Objects.equals(this.passwordExpiresOn, other.passwordExpiresOn);
    }
}

