/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.execution;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import lombok.Generated;
import org.apache.hop.core.exception.HopFileException;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.RowBuffer;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.execution.ExecutionDataSetMeta;
import org.apache.hop.execution.ExecutionDataSetMetaDeserializer;
import org.apache.hop.execution.ExecutionType;

public class ExecutionData {
    private ExecutionType executionType;
    private ExecutionDataSetMeta dataSetMeta;
    private boolean finished;
    private Date collectionDate;
    private String parentId;
    private String ownerId;
    @JsonIgnore
    private Map<String, RowBuffer> dataSets;
    @JsonDeserialize(using=ExecutionDataSetMetaDeserializer.class)
    private Map<String, ExecutionDataSetMeta> setMetaData;

    public ExecutionData() {
        this.collectionDate = new Date();
        this.dataSets = Collections.synchronizedMap(new HashMap());
        this.setMetaData = Collections.synchronizedMap(new HashMap());
    }

    public ExecutionData(Date collectionDate, String parentId, String ownerId, Map<String, RowBuffer> dataSets, Map<String, ExecutionDataSetMeta> setDescriptions) {
        this.collectionDate = collectionDate;
        this.parentId = parentId;
        this.ownerId = ownerId;
        this.dataSets = dataSets;
        this.setMetaData = setDescriptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExecutionData that = (ExecutionData)o;
        if (!(Objects.equals(this.collectionDate, that.collectionDate) && Objects.equals(this.parentId, that.parentId) && Objects.equals(this.ownerId, that.ownerId))) {
            return false;
        }
        if (this.dataSets.size() != that.dataSets.size()) {
            return false;
        }
        if (this.setMetaData.size() != that.setMetaData.size()) {
            return false;
        }
        for (String setKey : this.dataSets.keySet()) {
            RowBuffer thisBuffer = this.dataSets.get(setKey);
            RowBuffer thatBuffer = that.dataSets.get(setKey);
            if (thatBuffer == null) {
                return false;
            }
            if (thisBuffer.equals((Object)thatBuffer)) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.collectionDate, this.parentId, this.ownerId, this.dataSets, this.setMetaData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JsonInclude
    public String getRowsBinaryGzipBase64Encoded() throws IOException, HopFileException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        GZIPOutputStream gzos = new GZIPOutputStream(baos);
        DataOutputStream dataOutputStream = new DataOutputStream(gzos);
        Map<String, RowBuffer> map = this.dataSets;
        synchronized (map) {
            Map<String, ExecutionDataSetMeta> map2 = this.setMetaData;
            synchronized (map2) {
                dataOutputStream.writeInt(this.dataSets.keySet().size());
                for (String setKey : this.dataSets.keySet()) {
                    RowBuffer buffer = this.dataSets.get(setKey);
                    dataOutputStream.writeUTF(setKey);
                    IRowMeta rowMeta = buffer.getRowMeta();
                    if (rowMeta == null) {
                        rowMeta = new RowMeta();
                    }
                    rowMeta.writeMeta(dataOutputStream);
                    List list = buffer.getBuffer();
                    synchronized (list) {
                        List<Object[]> rows = buffer.getBuffer();
                        if (rows == null) {
                            rows = Collections.emptyList();
                        }
                        dataOutputStream.writeInt(rows.size());
                        for (Object[] row : rows) {
                            rowMeta.writeData(dataOutputStream, row);
                        }
                    }
                }
            }
        }
        dataOutputStream.close();
        gzos.close();
        byte[] compressedRowBytes = baos.toByteArray();
        return Base64.getEncoder().encodeToString(compressedRowBytes);
    }

    public void setRowsBinaryGzipBase64Encoded(String encodedString) throws IOException, HopFileException {
        this.dataSets = new HashMap<String, RowBuffer>();
        byte[] decodedCompressedBytes = Base64.getDecoder().decode(encodedString);
        ByteArrayInputStream bais = new ByteArrayInputStream(decodedCompressedBytes);
        try (GZIPInputStream gcis = new GZIPInputStream(bais);
             DataInputStream dis = new DataInputStream(gcis);){
            int nrSets = dis.readInt();
            for (int i = 0; i < nrSets; ++i) {
                String setKey = dis.readUTF();
                RowMeta rowMeta = new RowMeta(dis);
                ArrayList<Object[]> rows = new ArrayList<Object[]>();
                int nrRows = dis.readInt();
                for (int r = 0; r < nrRows; ++r) {
                    Object[] row = rowMeta.readData(dis);
                    rows.add(row);
                }
                this.dataSets.put(setKey, new RowBuffer((IRowMeta)rowMeta, rows));
            }
        }
    }

    @Generated
    public void setExecutionType(ExecutionType executionType) {
        this.executionType = executionType;
    }

    @Generated
    public void setDataSetMeta(ExecutionDataSetMeta dataSetMeta) {
        this.dataSetMeta = dataSetMeta;
    }

    @Generated
    public void setFinished(boolean finished) {
        this.finished = finished;
    }

    @Generated
    public void setCollectionDate(Date collectionDate) {
        this.collectionDate = collectionDate;
    }

    @Generated
    public void setParentId(String parentId) {
        this.parentId = parentId;
    }

    @Generated
    public void setOwnerId(String ownerId) {
        this.ownerId = ownerId;
    }

    @JsonIgnore
    @Generated
    public void setDataSets(Map<String, RowBuffer> dataSets) {
        this.dataSets = dataSets;
    }

    @JsonDeserialize(using=ExecutionDataSetMetaDeserializer.class)
    @Generated
    public void setSetMetaData(Map<String, ExecutionDataSetMeta> setMetaData) {
        this.setMetaData = setMetaData;
    }

    @Generated
    public ExecutionType getExecutionType() {
        return this.executionType;
    }

    @Generated
    public ExecutionDataSetMeta getDataSetMeta() {
        return this.dataSetMeta;
    }

    @Generated
    public boolean isFinished() {
        return this.finished;
    }

    @Generated
    public Date getCollectionDate() {
        return this.collectionDate;
    }

    @Generated
    public String getParentId() {
        return this.parentId;
    }

    @Generated
    public String getOwnerId() {
        return this.ownerId;
    }

    @Generated
    public Map<String, RowBuffer> getDataSets() {
        return this.dataSets;
    }

    @Generated
    public Map<String, ExecutionDataSetMeta> getSetMetaData() {
        return this.setMetaData;
    }
}

