/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.runners.fnexecution.control;

import java.util.ArrayList;
import java.util.List;
import org.apache.beam.model.fnexecution.v1.BeamFnApi;
import org.apache.beam.runners.fnexecution.control.BundleFinalizationHandler;
import org.apache.beam.runners.fnexecution.control.InstructionRequestHandler;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class BundleFinalizationHandlers {
    public static @UnknownKeyFor @NonNull @Initialized InMemoryFinalizer inMemoryFinalizer(@UnknownKeyFor @NonNull @Initialized InstructionRequestHandler fnApiControlClient) {
        return new InMemoryFinalizer(fnApiControlClient);
    }

    public static class InMemoryFinalizer
    implements BundleFinalizationHandler {
        private final @UnknownKeyFor @NonNull @Initialized InstructionRequestHandler fnApiControlClient;
        private final @UnknownKeyFor @NonNull @Initialized List<@UnknownKeyFor @NonNull @Initialized String> bundleIds;

        private InMemoryFinalizer(@UnknownKeyFor @NonNull @Initialized InstructionRequestHandler fnApiControlClient) {
            this.fnApiControlClient = fnApiControlClient;
            this.bundleIds = new ArrayList<String>();
        }

        public synchronized void finalizeAllOutstandingBundles() {
            for (String bundleId : this.bundleIds) {
                BeamFnApi.InstructionRequest request = BeamFnApi.InstructionRequest.newBuilder().setFinalizeBundle(BeamFnApi.FinalizeBundleRequest.newBuilder().setInstructionId(bundleId).build()).build();
                this.fnApiControlClient.handle(request);
            }
            this.bundleIds.clear();
        }

        @Override
        public synchronized void requestsFinalization(@UnknownKeyFor @NonNull @Initialized String bundleId) {
            this.bundleIds.add(bundleId);
        }
    }
}

