/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.kinesis.serde;

import com.amazonaws.auth.AWSCredentialsProvider;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import org.apache.beam.sdk.io.kinesis.serde.AwsModule;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class AwsSerializableUtils {
    public static @UnknownKeyFor @NonNull @Initialized String serialize(@UnknownKeyFor @NonNull @Initialized AWSCredentialsProvider awsCredentialsProvider) {
        ObjectMapper om = new ObjectMapper();
        om.registerModule((Module)new AwsModule());
        try {
            return om.writeValueAsString((Object)awsCredentialsProvider);
        }
        catch (JsonProcessingException e) {
            throw new IllegalArgumentException("AwsCredentialsProvider can not be serialized to Json", e);
        }
    }

    public static @UnknownKeyFor @NonNull @Initialized AWSCredentialsProvider deserialize(@UnknownKeyFor @NonNull @Initialized String awsCredentialsProviderSerialized) {
        ObjectMapper om = new ObjectMapper();
        om.registerModule((Module)new AwsModule());
        try {
            return (AWSCredentialsProvider)om.readValue(awsCredentialsProviderSerialized, AWSCredentialsProvider.class);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("AwsCredentialsProvider can not be deserialized from Json", e);
        }
    }
}

