/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.runtime.executiongraph;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.flink.runtime.executiongraph.EdgeManager;
import org.apache.flink.runtime.executiongraph.ExecutionVertex;
import org.apache.flink.runtime.executiongraph.IntermediateResult;
import org.apache.flink.runtime.io.network.partition.ResultPartitionType;
import org.apache.flink.runtime.jobgraph.DistributionPattern;
import org.apache.flink.runtime.jobgraph.IntermediateResultPartitionID;
import org.apache.flink.runtime.jobgraph.JobVertexID;
import org.apache.flink.runtime.scheduler.strategy.ConsumedPartitionGroup;
import org.apache.flink.runtime.scheduler.strategy.ConsumerVertexGroup;
import org.apache.flink.util.Preconditions;

public class IntermediateResultPartition {
    static final int NUM_SUBPARTITIONS_UNKNOWN = -1;
    private final IntermediateResult totalResult;
    private final ExecutionVertex producer;
    private final IntermediateResultPartitionID partitionId;
    private final EdgeManager edgeManager;
    private final int numberOfSubpartitionsForDynamicGraph;
    private boolean isNumberOfPartitionConsumersUndefined = false;
    private boolean dataAllProduced = false;
    private final Set<ConsumedPartitionGroup> releasablePartitionGroups = new HashSet<ConsumedPartitionGroup>();

    public IntermediateResultPartition(IntermediateResult totalResult, ExecutionVertex producer, int partitionNumber, EdgeManager edgeManager) {
        this.totalResult = totalResult;
        this.producer = producer;
        this.partitionId = new IntermediateResultPartitionID(totalResult.getId(), partitionNumber);
        this.edgeManager = edgeManager;
        if (!producer.getExecutionGraphAccessor().isDynamic()) {
            this.numberOfSubpartitionsForDynamicGraph = -1;
        } else {
            this.numberOfSubpartitionsForDynamicGraph = this.computeNumberOfSubpartitionsForDynamicGraph();
            Preconditions.checkState((this.numberOfSubpartitionsForDynamicGraph > 0 ? 1 : 0) != 0, (Object)("Number of subpartitions is an unexpected value: " + this.numberOfSubpartitionsForDynamicGraph));
        }
    }

    public void markPartitionGroupReleasable(ConsumedPartitionGroup partitionGroup) {
        this.releasablePartitionGroups.add(partitionGroup);
    }

    public boolean canBeReleased() {
        if (this.releasablePartitionGroups.size() != this.edgeManager.getNumberOfConsumedPartitionGroupsById(this.partitionId)) {
            return false;
        }
        for (JobVertexID jobVertexId : this.totalResult.getConsumerVertices()) {
            if (this.producer.getExecutionGraphAccessor().getJobVertex(jobVertexId).isInitialized()) continue;
            return false;
        }
        return true;
    }

    public ExecutionVertex getProducer() {
        return this.producer;
    }

    public int getPartitionNumber() {
        return this.partitionId.getPartitionNumber();
    }

    public IntermediateResult getIntermediateResult() {
        return this.totalResult;
    }

    public IntermediateResultPartitionID getPartitionId() {
        return this.partitionId;
    }

    public ResultPartitionType getResultType() {
        return this.totalResult.getResultType();
    }

    public List<ConsumerVertexGroup> getConsumerVertexGroups() {
        return this.getEdgeManager().getConsumerVertexGroupsForPartition(this.partitionId);
    }

    public List<ConsumedPartitionGroup> getConsumedPartitionGroups() {
        return this.getEdgeManager().getConsumedPartitionGroupsById(this.partitionId);
    }

    public boolean isNumberOfPartitionConsumersUndefined() {
        this.getNumberOfSubpartitions();
        return this.isNumberOfPartitionConsumersUndefined;
    }

    public int getNumberOfSubpartitions() {
        if (!this.getProducer().getExecutionGraphAccessor().isDynamic()) {
            List<ConsumerVertexGroup> consumerVertexGroups = this.getConsumerVertexGroups();
            Preconditions.checkState((!consumerVertexGroups.isEmpty() ? 1 : 0) != 0);
            return consumerVertexGroups.get(0).size();
        }
        return this.numberOfSubpartitionsForDynamicGraph;
    }

    private int computeNumberOfSubpartitionsForDynamicGraph() {
        if (this.totalResult.isBroadcast()) {
            return 1;
        }
        return this.computeNumberOfMaxPossiblePartitionConsumers();
    }

    private int computeNumberOfMaxPossiblePartitionConsumers() {
        this.isNumberOfPartitionConsumersUndefined = true;
        DistributionPattern distributionPattern = this.getIntermediateResult().getConsumingDistributionPattern();
        int maxConsumerJobVertexParallelism = this.getIntermediateResult().getConsumersParallelism();
        if (maxConsumerJobVertexParallelism <= 0) {
            maxConsumerJobVertexParallelism = this.getIntermediateResult().getConsumersMaxParallelism();
            Preconditions.checkState((maxConsumerJobVertexParallelism > 0 ? 1 : 0) != 0, (Object)"Neither the parallelism nor the max parallelism of a job vertex is set");
        }
        if (distributionPattern == DistributionPattern.ALL_TO_ALL) {
            return maxConsumerJobVertexParallelism;
        }
        int numberOfPartitions = this.getIntermediateResult().getNumParallelProducers();
        return (int)Math.ceil((double)maxConsumerJobVertexParallelism / (double)numberOfPartitions);
    }

    public boolean hasDataAllProduced() {
        return this.dataAllProduced;
    }

    void resetForNewExecution() {
        if (!this.getResultType().canBePipelinedConsumed() && this.dataAllProduced) {
            for (ConsumedPartitionGroup consumedPartitionGroup : this.getConsumedPartitionGroups()) {
                consumedPartitionGroup.partitionUnfinished();
            }
        }
        this.releasablePartitionGroups.clear();
        this.dataAllProduced = false;
        for (ConsumedPartitionGroup consumedPartitionGroup : this.getConsumedPartitionGroups()) {
            this.totalResult.clearCachedInformationForPartitionGroup(consumedPartitionGroup);
        }
    }

    public void addConsumers(ConsumerVertexGroup consumers) {
        this.getEdgeManager().connectPartitionWithConsumerVertexGroup(this.partitionId, consumers);
    }

    private EdgeManager getEdgeManager() {
        return this.edgeManager;
    }

    void markFinished() {
        if (this.getResultType().mustBePipelinedConsumed()) {
            throw new IllegalStateException("Tried to mark a must-be-pipelined result partition as finished");
        }
        if (this.dataAllProduced) {
            throw new IllegalStateException("Tried to mark a finished result partition as finished.");
        }
        this.dataAllProduced = true;
        for (ConsumedPartitionGroup consumedPartitionGroup : this.getConsumedPartitionGroups()) {
            this.totalResult.markPartitionFinished(consumedPartitionGroup, this);
            consumedPartitionGroup.partitionFinished();
        }
    }
}

