/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.pipeline.transforms.sql;

import java.util.ArrayList;
import org.apache.hop.core.Const;
import org.apache.hop.core.Result;
import org.apache.hop.core.RowMetaAndData;
import org.apache.hop.core.database.Database;
import org.apache.hop.core.database.DatabaseMeta;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.exception.HopTransformException;
import org.apache.hop.core.logging.ILoggingObject;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.RowDataUtil;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaInteger;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.i18n.BaseMessages;
import org.apache.hop.pipeline.Pipeline;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransform;
import org.apache.hop.pipeline.transform.ITransformData;
import org.apache.hop.pipeline.transform.ITransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;
import org.apache.hop.pipeline.transforms.sql.ExecSqlData;
import org.apache.hop.pipeline.transforms.sql.ExecSqlMeta;

public class ExecSql
extends BaseTransform<ExecSqlMeta, ExecSqlData> {
    private static final Class<?> PKG = ExecSqlMeta.class;

    public ExecSql(TransformMeta transformMeta, ExecSqlMeta meta, ExecSqlData data, int copyNr, PipelineMeta pipelineMeta, Pipeline pipeline) {
        super(transformMeta, (ITransformMeta)meta, (ITransformData)data, copyNr, pipelineMeta, pipeline);
    }

    public static final RowMetaAndData getResultRow(Result result, String upd, String ins, String del, String read) {
        ValueMetaInteger meta;
        RowMetaAndData resultRow = new RowMetaAndData();
        if (upd != null && upd.length() > 0) {
            meta = new ValueMetaInteger(upd);
            meta.setLength(10, 0);
            resultRow.addValue((IValueMeta)meta, (Object)result.getNrLinesUpdated());
        }
        if (ins != null && ins.length() > 0) {
            meta = new ValueMetaInteger(ins);
            meta.setLength(10, 0);
            resultRow.addValue((IValueMeta)meta, (Object)result.getNrLinesOutput());
        }
        if (del != null && del.length() > 0) {
            meta = new ValueMetaInteger(del);
            meta.setLength(10, 0);
            resultRow.addValue((IValueMeta)meta, (Object)result.getNrLinesDeleted());
        }
        if (read != null && read.length() > 0) {
            meta = new ValueMetaInteger(read);
            meta.setLength(10, 0);
            resultRow.addValue((IValueMeta)meta, (Object)result.getNrLinesRead());
        }
        return resultRow;
    }

    public boolean processRow() throws HopException {
        block21: {
            String sql;
            if (!((ExecSqlMeta)this.meta).isExecutedEachInputRow()) {
                RowMetaAndData resultRow = ExecSql.getResultRow(((ExecSqlData)this.data).result, ((ExecSqlMeta)this.meta).getUpdateField(), ((ExecSqlMeta)this.meta).getInsertField(), ((ExecSqlMeta)this.meta).getDeleteField(), ((ExecSqlMeta)this.meta).getReadField());
                this.putRow(resultRow.getRowMeta(), resultRow.getData());
                this.setOutputDone();
                return false;
            }
            Object[] row = this.getRow();
            if (row == null) {
                this.setOutputDone();
                return false;
            }
            if (this.first) {
                this.first = false;
                ((ExecSqlData)this.data).outputRowMeta = this.getInputRowMeta().clone();
                ((ExecSqlMeta)this.meta).getFields(((ExecSqlData)this.data).outputRowMeta, this.getTransformName(), null, null, (IVariables)this, this.metadataProvider);
                ((ExecSqlData)this.data).argumentIndexes = new int[((ExecSqlMeta)this.meta).getArguments().size()];
                for (int i = 0; i < ((ExecSqlMeta)this.meta).getArguments().size(); ++i) {
                    String arg = ((ExecSqlMeta)this.meta).getArguments().get(i).getName();
                    ((ExecSqlData)this.data).argumentIndexes[i] = this.getInputRowMeta().indexOfValue(arg);
                    if (((ExecSqlData)this.data).argumentIndexes[i] < 0) {
                        this.logError(BaseMessages.getString(PKG, (String)"ExecSql.Log.ErrorFindingField", (String[])new String[0]) + arg + "]");
                        throw new HopTransformException(BaseMessages.getString(PKG, (String)"ExecSql.Exception.CouldNotFindField", (String[])new String[]{arg}));
                    }
                    if (!((ExecSqlMeta)this.meta).isParams()) continue;
                    if (i == 0) {
                        ((ExecSqlData)this.data).paramsMeta = new RowMeta();
                    }
                    ((ExecSqlData)this.data).paramsMeta.addValueMeta(this.getInputRowMeta().getValueMeta(((ExecSqlData)this.data).argumentIndexes[i]));
                }
                if (!((ExecSqlMeta)this.meta).isParams()) {
                    ((ExecSqlData)this.data).markerPositions = new ArrayList<Integer>();
                    int len = ((ExecSqlData)this.data).sql.length();
                    for (int pos = len - 1; pos >= 0; --pos) {
                        if (((ExecSqlData)this.data).sql.charAt(pos) != '?') continue;
                        ((ExecSqlData)this.data).markerPositions.add(pos);
                    }
                }
            }
            Object[] paramsData = null;
            if (((ExecSqlMeta)this.meta).isParams()) {
                paramsData = new Object[((ExecSqlData)this.data).argumentIndexes.length];
                sql = ((ExecSqlData)this.data).sql;
                for (int i = 0; i < ((ExecSqlData)this.data).argumentIndexes.length; ++i) {
                    paramsData[i] = row[((ExecSqlData)this.data).argumentIndexes[i]];
                }
            } else {
                int numMarkers = ((ExecSqlData)this.data).markerPositions.size();
                if (numMarkers > 0) {
                    StringBuilder buf = new StringBuilder(((ExecSqlData)this.data).sql);
                    DatabaseMeta dbMeta = this.getPipelineMeta().findDatabase(((ExecSqlMeta)this.meta).getConnection(), this.variables);
                    for (int i = 0; i < numMarkers; ++i) {
                        int index = ((ExecSqlData)this.data).argumentIndexes[((ExecSqlData)this.data).markerPositions.size() - i - 1];
                        IValueMeta valueMeta = this.getInputRowMeta().getValueMeta(index);
                        Object valueData = row[index];
                        int pos = ((ExecSqlData)this.data).markerPositions.get(i);
                        String replaceValue = valueMeta.getString(valueData);
                        replaceValue = Const.NVL((String)replaceValue, (String)"");
                        if (((ExecSqlMeta)this.meta).isQuoteString() && valueMeta.getType() == 2) {
                            replaceValue = dbMeta.quoteSqlString(replaceValue);
                        }
                        buf.replace(pos, pos + 1, replaceValue);
                    }
                    sql = buf.toString();
                } else {
                    sql = ((ExecSqlData)this.data).sql;
                }
            }
            if (this.isRowLevel()) {
                this.logRowlevel(BaseMessages.getString(PKG, (String)"ExecSql.Log.ExecutingSQLScript", (String[])new String[0]) + Const.CR + sql);
            }
            boolean sendToErrorRow = false;
            String errorMessage = null;
            try {
                ((ExecSqlData)this.data).result = ((ExecSqlMeta)this.meta).isSingleStatement() ? ((ExecSqlData)this.data).db.execStatement(sql, ((ExecSqlData)this.data).paramsMeta, paramsData) : ((ExecSqlData)this.data).db.execStatements(sql, ((ExecSqlData)this.data).paramsMeta, paramsData);
                RowMetaAndData add = ExecSql.getResultRow(((ExecSqlData)this.data).result, ((ExecSqlMeta)this.meta).getUpdateField(), ((ExecSqlMeta)this.meta).getInsertField(), ((ExecSqlMeta)this.meta).getDeleteField(), ((ExecSqlMeta)this.meta).getReadField());
                row = RowDataUtil.addRowData((Object[])row, (int)this.getInputRowMeta().size(), (Object[])add.getData());
                if (!((ExecSqlData)this.data).db.isAutoCommit()) {
                    ((ExecSqlData)this.data).db.commit();
                }
                this.putRow(((ExecSqlData)this.data).outputRowMeta, row);
                if (this.checkFeedback(this.getLinesWritten()) && this.isBasic()) {
                    this.logBasic(BaseMessages.getString(PKG, (String)"ExecSql.Log.LineNumber", (String[])new String[0]) + this.getLinesWritten());
                }
            }
            catch (HopException e) {
                if (!this.getTransformMeta().isDoingErrorHandling()) {
                    throw new HopTransformException(BaseMessages.getString(PKG, (String)"ExecSql.Log.ErrorInTransform", (String[])new String[0]), (Throwable)e);
                }
                sendToErrorRow = true;
                errorMessage = e.toString();
                if (!sendToErrorRow) break block21;
                this.putError(this.getInputRowMeta(), row, 1L, errorMessage, null, "ExecSql001");
            }
        }
        return true;
    }

    public void dispose() {
        if (this.isBasic()) {
            this.logBasic(BaseMessages.getString(PKG, (String)"ExecSql.Log.FinishingReadingQuery", (String[])new String[0]));
        }
        if (((ExecSqlData)this.data).db != null) {
            ((ExecSqlData)this.data).db.disconnect();
        }
        super.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopRunning() throws HopException {
        if (((ExecSqlData)this.data).db != null && !((ExecSqlData)this.data).isCanceled) {
            Database database = ((ExecSqlData)this.data).db;
            synchronized (database) {
                ((ExecSqlData)this.data).db.cancelQuery();
            }
            ((ExecSqlData)this.data).isCanceled = true;
        }
    }

    public boolean init() {
        if (super.init()) {
            if (((ExecSqlMeta)this.meta).getConnection() == null) {
                this.logError(BaseMessages.getString(PKG, (String)"ExecSql.Init.ConnectionMissing", (String[])new String[]{this.getTransformName()}));
                return false;
            }
            DatabaseMeta databaseMeta = this.getPipelineMeta().findDatabase(((ExecSqlMeta)this.meta).getConnection(), this.variables);
            ((ExecSqlData)this.data).db = new Database((ILoggingObject)this, (IVariables)this, databaseMeta);
            try {
                ((ExecSqlData)this.data).db.connect();
                if (this.isDetailed()) {
                    this.logDetailed(BaseMessages.getString(PKG, (String)"ExecSql.Log.ConnectedToDB", (String[])new String[0]));
                }
                ((ExecSqlData)this.data).sql = ((ExecSqlMeta)this.meta).isReplaceVariables() ? this.resolve(((ExecSqlMeta)this.meta).getSql()) : ((ExecSqlMeta)this.meta).getSql();
                if (!((ExecSqlMeta)this.meta).isExecutedEachInputRow()) {
                    ((ExecSqlData)this.data).result = ((ExecSqlMeta)this.meta).isSingleStatement() ? ((ExecSqlData)this.data).db.execStatement(((ExecSqlData)this.data).sql) : ((ExecSqlData)this.data).db.execStatements(((ExecSqlData)this.data).sql);
                    if (!((ExecSqlData)this.data).db.isAutoCommit()) {
                        ((ExecSqlData)this.data).db.commit();
                    }
                }
                return true;
            }
            catch (HopException e) {
                this.logError(BaseMessages.getString(PKG, (String)"ExecSql.Log.ErrorOccurred", (String[])new String[0]) + e.getMessage());
                this.setErrors(1L);
                this.stopAll();
            }
        }
        return false;
    }
}

