/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.transforms.hivecatalog;

import java.util.List;
import java.util.Map;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PCollection;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.transform.BeamHiveMetastoreInputTransform;
import org.apache.hop.beam.engines.IBeamPipelineEngineRunConfiguration;
import org.apache.hop.beam.pipeline.IBeamPipelineTransformHandler;
import org.apache.hop.beam.transforms.hivecatalog.BeamHiveCatalogInput;
import org.apache.hop.beam.transforms.hivecatalog.BeamHiveCatalogInputData;
import org.apache.hop.beam.transforms.hivecatalog.BeamHiveCatalogInputDialog;
import org.apache.hop.core.annotations.Transform;
import org.apache.hop.core.exception.HopException;
import org.apache.hop.core.logging.ILogChannel;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.IValueMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.apache.hop.core.row.RowMeta;
import org.apache.hop.core.row.value.ValueMetaString;
import org.apache.hop.core.variables.IVariables;
import org.apache.hop.metadata.api.HopMetadataProperty;
import org.apache.hop.metadata.api.IHopMetadataProvider;
import org.apache.hop.pipeline.PipelineMeta;
import org.apache.hop.pipeline.transform.BaseTransformMeta;
import org.apache.hop.pipeline.transform.TransformMeta;

@Transform(id="BeamHiveCatalogInput", image="beam-input.svg", name="i18n::BeamHiveCatalogInputDialog.DialogTitle", description="i18n::BeamHiveCatalogInputDialog.Description", categoryDescription="i18n:org.apache.hop.pipeline.transform:BaseTransform.Category.Experimental", keywords={"i18n::BeamHiveCatalogInputDialog.keyword"}, documentationUrl="/pipeline/transforms/beamhivecataloginput.html")
public class BeamHiveCatalogInputMeta
extends BaseTransformMeta<BeamHiveCatalogInput, BeamHiveCatalogInputData>
implements IBeamPipelineTransformHandler {
    @HopMetadataProperty(key="hive_metastore_uris")
    private String hiveMetastoreUris;
    @HopMetadataProperty(key="hive_metastore_databese")
    private String hiveMetastoreDatabase;
    @HopMetadataProperty(key="hive_metastore_table")
    private String hiveMetastoreTable;

    public String getDialogClassName() {
        return BeamHiveCatalogInputDialog.class.getName();
    }

    public boolean isInput() {
        return true;
    }

    public boolean isOutput() {
        return false;
    }

    public void handleTransform(ILogChannel log, IVariables variables, String runConfigurationName, IBeamPipelineEngineRunConfiguration runConfiguration, String dataSamplersJson, IHopMetadataProvider metadataProvider, PipelineMeta pipelineMeta, TransformMeta transformMeta, Map<String, PCollection<HopRow>> transformCollectionMap, Pipeline pipeline, IRowMeta rowMeta, List<TransformMeta> previousTransforms, PCollection<HopRow> input, String parentLogChannelId) throws HopException {
        RowMeta outputRowMeta = new RowMeta();
        this.getFields((IRowMeta)outputRowMeta, transformMeta.getName(), null, null, variables, null);
        BeamHiveMetastoreInputTransform beamInputTransform = new BeamHiveMetastoreInputTransform(transformMeta.getName(), transformMeta.getName(), variables.resolve(this.hiveMetastoreUris), variables.resolve(this.hiveMetastoreDatabase), variables.resolve(this.hiveMetastoreTable), JsonRowMeta.toJson((IRowMeta)outputRowMeta));
        PCollection afterInput = (PCollection)pipeline.apply((PTransform)beamInputTransform);
        transformCollectionMap.put(transformMeta.getName(), (PCollection<HopRow>)afterInput);
        log.logBasic("Handled transform (Hive Catalog INPUT) : " + transformMeta.getName());
    }

    public String getHiveMetastoreUris() {
        return this.hiveMetastoreUris;
    }

    public void setHiveMetastoreUris(String hiveMetastoreUris) {
        this.hiveMetastoreUris = hiveMetastoreUris;
    }

    public String getHiveMetastoreDatabase() {
        return this.hiveMetastoreDatabase;
    }

    public void setHiveMetastoreDatabase(String hiveMetastoreDatabase) {
        this.hiveMetastoreDatabase = hiveMetastoreDatabase;
    }

    public String getHiveMetastoreTable() {
        return this.hiveMetastoreTable;
    }

    public void setHiveMetastoreTable(String hiveMetastoreTable) {
        this.hiveMetastoreTable = hiveMetastoreTable;
    }

    public void getFields(IRowMeta inputRowMeta, String name, IRowMeta[] info, TransformMeta nextTransform, IVariables variables, IHopMetadataProvider metadataProvider) {
        ValueMetaString rowNb = new ValueMetaString();
        rowNb.setOrigin(name);
        rowNb.setName("hcatalog_output");
        inputRowMeta.addValueMeta((IValueMeta)rowNb);
    }
}

