/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hop.beam.core.transform;

import org.apache.beam.sdk.io.gcp.pubsub.PubsubIO;
import org.apache.beam.sdk.metrics.Counter;
import org.apache.beam.sdk.metrics.Metrics;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.hop.beam.core.BeamHop;
import org.apache.hop.beam.core.HopRow;
import org.apache.hop.beam.core.fn.PublishMessagesFn;
import org.apache.hop.beam.core.fn.PublishStringsFn;
import org.apache.hop.core.row.IRowMeta;
import org.apache.hop.core.row.JsonRowMeta;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeamPublishTransform
extends PTransform<PCollection<HopRow>, PDone> {
    private String transformName;
    private String topic;
    private String messageType;
    private String messageField;
    private String rowMetaJson;
    private static final Logger LOG = LoggerFactory.getLogger(BeamPublishTransform.class);
    private transient IRowMeta rowMeta;
    private transient Counter errorCounter;
    private transient int fieldIndex;

    public BeamPublishTransform() {
    }

    public BeamPublishTransform(String transformName, String topic, String messageType, String messageField, String rowMetaJson) {
        this.transformName = transformName;
        this.topic = topic;
        this.messageType = messageType;
        this.messageField = messageField;
        this.rowMetaJson = rowMetaJson;
    }

    public PDone expand(PCollection<HopRow> input) {
        try {
            if (this.rowMeta == null) {
                BeamHop.init();
                IRowMeta rowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
                rowMeta = JsonRowMeta.fromJson((String)this.rowMetaJson);
                Counter initCounter = Metrics.counter((String)"init", (String)this.transformName);
                Counter readCounter = Metrics.counter((String)"read", (String)this.transformName);
                Counter outputCounter = Metrics.counter((String)"output", (String)this.transformName);
                this.errorCounter = Metrics.counter((String)"error", (String)this.transformName);
                this.fieldIndex = rowMeta.indexOfValue(this.messageField);
                if (this.fieldIndex < 0) {
                    throw new RuntimeException("Field '" + this.messageField + "' couldn't be found in the input row: " + rowMeta.toString());
                }
                initCounter.inc();
            }
            if ("String".equalsIgnoreCase(this.messageType)) {
                PublishStringsFn stringsFn = new PublishStringsFn(this.transformName, this.fieldIndex, this.rowMetaJson);
                PCollection stringPCollection = (PCollection)input.apply(this.transformName, (PTransform)ParDo.of((DoFn)stringsFn));
                return PubsubIO.writeStrings().to(this.topic).expand(stringPCollection);
            }
            if ("PubsubMessage".equalsIgnoreCase(this.messageType)) {
                PublishMessagesFn messagesFn = new PublishMessagesFn(this.transformName, this.fieldIndex, this.rowMetaJson);
                PCollection messagesPCollection = (PCollection)input.apply((PTransform)ParDo.of((DoFn)messagesFn));
                return PubsubIO.writeMessages().to(this.topic).expand(messagesPCollection);
            }
            throw new RuntimeException("Message type '" + this.messageType + "' is not yet supported");
        }
        catch (Exception e) {
            this.errorCounter.inc();
            LOG.error("Error in beam publish transform", (Throwable)e);
            throw new RuntimeException("Error in beam publish transform", e);
        }
    }

    public String getTransformName() {
        return this.transformName;
    }

    public void setTransformName(String transformName) {
        this.transformName = transformName;
    }

    public String getTopic() {
        return this.topic;
    }

    public void setTopic(String topic) {
        this.topic = topic;
    }

    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    public String getMessageField() {
        return this.messageField;
    }

    public void setMessageField(String messageField) {
        this.messageField = messageField;
    }
}

