/*
 * Decompiled with CFR 0.152.
 */
package io.github.spannm.jackcess;

import io.github.spannm.jackcess.Index;
import io.github.spannm.jackcess.Table;
import io.github.spannm.jackcess.TableDefinition;
import io.github.spannm.jackcess.impl.DatabaseImpl;
import io.github.spannm.jackcess.impl.JetFormat;
import io.github.spannm.jackcess.impl.TableImpl;
import io.github.spannm.jackcess.impl.TableUpdater;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class IndexBuilder {
    public static final String PRIMARY_KEY_NAME = "PrimaryKey";
    private String _name;
    private byte _type;
    private byte _flags = (byte)-128;
    private final List<Column> _columns = new ArrayList<Column>();
    private int _indexNumber;

    public IndexBuilder(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public byte getType() {
        return this._type;
    }

    public byte getFlags() {
        return this._flags;
    }

    public boolean isPrimaryKey() {
        return this.getType() == 1;
    }

    public boolean isUnique() {
        return (this.getFlags() & 1) != 0;
    }

    public boolean isIgnoreNulls() {
        return (this.getFlags() & 2) != 0;
    }

    public List<Column> getColumns() {
        return this._columns;
    }

    public IndexBuilder withName(String name) {
        this._name = name;
        return this;
    }

    public IndexBuilder withColumns(String ... names) {
        return this.withColumns(true, names);
    }

    public IndexBuilder withColumns(boolean ascending, String ... names) {
        return names != null ? this.withColumns(ascending, Arrays.asList(names)) : this;
    }

    public IndexBuilder withColumns(Iterable<String> names) {
        return this.withColumns(true, names);
    }

    public IndexBuilder withColumns(boolean ascending, Iterable<String> names) {
        if (names != null) {
            for (String name : names) {
                this._columns.add(new Column(name, ascending));
            }
        }
        return this;
    }

    public IndexBuilder withPrimaryKey() {
        this._type = 1;
        this.withRequired();
        return this.withUnique();
    }

    public IndexBuilder withType(byte type) {
        this._type = type;
        return this;
    }

    public IndexBuilder withUnique() {
        this._flags = (byte)(this._flags | 1);
        return this;
    }

    public IndexBuilder withRequired() {
        this._flags = (byte)(this._flags | 8);
        return this;
    }

    public IndexBuilder withIgnoreNulls() {
        this._flags = (byte)(this._flags | 2);
        return this;
    }

    public int getIndexNumber() {
        return this._indexNumber;
    }

    public void setIndexNumber(int newIndexNumber) {
        this._indexNumber = newIndexNumber;
    }

    public void validate(Set<String> tableColNames, JetFormat format) {
        DatabaseImpl.validateIdentifierName(this.getName(), format.MAX_INDEX_NAME_LENGTH, "index");
        if (this.getColumns().isEmpty()) {
            throw new IllegalArgumentException(this.withErrorContext("index has no columns"));
        }
        if (this.getColumns().size() > 10) {
            throw new IllegalArgumentException(this.withErrorContext("index has too many columns, max 10"));
        }
        HashSet<String> idxColNames = new HashSet<String>();
        for (Column col : this.getColumns()) {
            String idxColName = col.getName().toUpperCase();
            if (!idxColNames.add(idxColName)) {
                throw new IllegalArgumentException(this.withErrorContext("duplicate column name " + col.getName() + " in index"));
            }
            if (tableColNames.contains(idxColName)) continue;
            throw new IllegalArgumentException(this.withErrorContext("column named " + col.getName() + " not found in table"));
        }
    }

    public Index addToTable(Table table) throws IOException {
        return this.addToTableDefinition(table);
    }

    public Index addToTableDefinition(TableDefinition table) throws IOException {
        return new TableUpdater((TableImpl)table).addIndex(this);
    }

    private String withErrorContext(String msg) {
        return msg + "(Index=" + this.getName() + ")";
    }

    public static class Column {
        private String _name;
        private final byte _flags;

        private Column(String name, boolean ascending) {
            this._name = name;
            this._flags = ascending ? (byte)1 : 0;
        }

        public String getName() {
            return this._name;
        }

        public Column withName(String name) {
            this._name = name;
            return this;
        }

        public boolean isAscending() {
            return (this.getFlags() & 1) != 0;
        }

        public byte getFlags() {
            return this._flags;
        }
    }
}

