/*
 *  Licensed to the Apache Software Foundation (ASF) under one
 *  or more contributor license agreements.  See the NOTICE file
 *  distributed with this work for additional information
 *  regarding copyright ownership.  The ASF licenses this file
 *  to you under the Apache License, Version 2.0 (the
 *  "License"); you may not use this file except in compliance
 *  with the License.  You may obtain a copy of the License at
 *
 *    https://www.apache.org/licenses/LICENSE-2.0
 *
 *  Unless required by applicable law or agreed to in writing,
 *  software distributed under the License is distributed on an
 *  "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 *  KIND, either express or implied.  See the License for the
 *  specific language governing permissions and limitations
 *  under the License.
 */
package org.grails.cli.profile.repository

import grails.util.Environment
import spock.lang.IgnoreIf
import spock.lang.Specification

/**
 * @author graemerocher
 */

// Note: These tests will fail on a new SNAPSHOT version until the corresponding
// grails-bom has been published for the first time.
@IgnoreIf({ Environment.grailsVersion?.endsWith('SNAPSHOT') })
class MavenRepositorySpec extends Specification {

    void "Test resolve profile"() {
        given:"A maven profile repository"
        def repo = new MavenProfileRepository()

        when:"We resolve the web profile"
        def profile = repo.getProfile("web")

        then:"The profile is not null"
        profile != null
        profile.name == 'web'
    }

    void "Test list all profiles"() {
        given:"A maven profile repository"
        def repo = new MavenProfileRepository()

        when:"We resolve the web profile"
        def profiles = repo.allProfiles

        then:"The profiles are not null or empty"
        profiles
    }
}