/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.agents.runtime.memory;

import java.util.HashMap;
import java.util.Map;
import org.apache.flink.agents.runtime.memory.MemoryObjectImpl;
import org.apache.flink.agents.runtime.memory.MemoryStore;
import org.apache.flink.api.common.state.MapState;

public class CachedMemoryStore
implements MemoryStore {
    private final Map<String, MemoryObjectImpl.MemoryItem> cache;
    private final MapState<String, MemoryObjectImpl.MemoryItem> store;

    public CachedMemoryStore(MapState<String, MemoryObjectImpl.MemoryItem> store) {
        this.store = store;
        this.cache = new HashMap<String, MemoryObjectImpl.MemoryItem>();
    }

    @Override
    public MemoryObjectImpl.MemoryItem get(String key) throws Exception {
        if (this.cache.containsKey(key)) {
            return this.cache.get(key);
        }
        return (MemoryObjectImpl.MemoryItem)this.store.get((Object)key);
    }

    @Override
    public void put(String key, MemoryObjectImpl.MemoryItem value) throws Exception {
        this.cache.put(key, value);
    }

    @Override
    public boolean contains(String key) throws Exception {
        return this.cache.containsKey(key) || this.store.contains((Object)key);
    }

    public void persistCache() throws Exception {
        for (Map.Entry<String, MemoryObjectImpl.MemoryItem> entry : this.cache.entrySet()) {
            this.store.put((Object)entry.getKey(), (Object)entry.getValue());
        }
        this.cache.clear();
    }
}

