/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.base.internal.whiteboard.tracker;

import jakarta.servlet.Filter;
import org.apache.felix.http.base.internal.runtime.FilterInfo;
import org.apache.felix.http.base.internal.runtime.WhiteboardServiceInfo;
import org.apache.felix.http.base.internal.util.ServiceUtils;
import org.apache.felix.http.base.internal.whiteboard.WhiteboardManager;
import org.apache.felix.http.base.internal.whiteboard.tracker.WhiteboardServiceTracker;
import org.apache.felix.http.jakartawrappers.FilterWrapper;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;

public final class JavaxFilterTracker
extends WhiteboardServiceTracker<Filter> {
    public JavaxFilterTracker(BundleContext context, WhiteboardManager manager) {
        super(manager, context, String.format("(&(objectClass=%s)(|(%s=*)(%s=*)(%s=*)))", javax.servlet.Filter.class.getName(), "osgi.http.whiteboard.filter.pattern", "osgi.http.whiteboard.filter.regex", "osgi.http.whiteboard.filter.servlet"));
    }

    @Override
    protected WhiteboardServiceInfo<Filter> getServiceInfo(ServiceReference<Filter> ref) {
        return new JavaxFilterInfo(ref);
    }

    private static final class JavaxFilterInfo
    extends FilterInfo {
        private final ServiceReference<javax.servlet.Filter> reference;

        public JavaxFilterInfo(ServiceReference<Filter> ref) {
            super(ref);
            this.reference = ref;
        }

        @Override
        public Filter getService(BundleContext bundleContext) {
            javax.servlet.Filter filter = ServiceUtils.safeGetServiceObjects(bundleContext, this.reference);
            if (filter == null) {
                return null;
            }
            return new FilterWrapper(filter);
        }

        @Override
        public void ungetService(BundleContext bundleContext, Filter service) {
            if (service instanceof FilterWrapper) {
                javax.servlet.Filter filter = ((FilterWrapper)service).getFilter();
                ServiceUtils.safeUngetServiceObjects(bundleContext, this.reference, filter);
            }
        }
    }
}

