/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.tuple;

import java.lang.foreign.MemorySegment;
import java.lang.foreign.ValueLayout;
import java.lang.reflect.Array;
import java.util.Objects;
import org.apache.datasketches.common.ByteArrayUtil;
import org.apache.datasketches.common.Family;
import org.apache.datasketches.common.QuickSelect;
import org.apache.datasketches.common.ResizeFactor;
import org.apache.datasketches.common.SketchesArgumentException;
import org.apache.datasketches.thetacommon.HashOperations;
import org.apache.datasketches.tuple.CompactTupleSketch;
import org.apache.datasketches.tuple.DeserializeResult;
import org.apache.datasketches.tuple.SerializerDeserializer;
import org.apache.datasketches.tuple.Summary;
import org.apache.datasketches.tuple.SummaryDeserializer;
import org.apache.datasketches.tuple.SummaryFactory;
import org.apache.datasketches.tuple.SummarySetOperations;
import org.apache.datasketches.tuple.TupleSketch;
import org.apache.datasketches.tuple.TupleSketchIterator;
import org.apache.datasketches.tuple.Util;

class QuickSelectSketch<S extends Summary>
extends TupleSketch<S> {
    private static final byte serialVersionUID = 2;
    private static final int DEFAULT_LG_RESIZE_FACTOR = ResizeFactor.X8.lg();
    private final int nomEntries_;
    private final int lgResizeFactor_;
    private final float samplingProbability_;
    private int lgCurrentCapacity_;
    private int retEntries_;
    private int rebuildThreshold_;
    private long[] hashTable_;
    S[] summaryTable_;

    QuickSelectSketch(int nomEntries, SummaryFactory<S> summaryFactory) {
        this(nomEntries, DEFAULT_LG_RESIZE_FACTOR, summaryFactory);
    }

    QuickSelectSketch(int nomEntries, int lgResizeFactor, SummaryFactory<S> summaryFactory) {
        this(nomEntries, lgResizeFactor, 1.0f, summaryFactory);
    }

    QuickSelectSketch(int nomEntries, int lgResizeFactor, float samplingProbability, SummaryFactory<S> summaryFactory) {
        this(nomEntries, lgResizeFactor, samplingProbability, summaryFactory, Util.getStartingCapacity(nomEntries, lgResizeFactor));
    }

    private QuickSelectSketch(int nomEntries, int lgResizeFactor, float samplingProbability, SummaryFactory<S> summaryFactory, int startingSize) {
        long thetaLong = (long)(9.223372036854776E18 * (double)samplingProbability);
        super(thetaLong, true, summaryFactory);
        this.nomEntries_ = org.apache.datasketches.common.Util.ceilingPowerOf2(nomEntries);
        this.lgResizeFactor_ = lgResizeFactor;
        this.samplingProbability_ = samplingProbability;
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(startingSize);
        this.retEntries_ = 0;
        this.hashTable_ = new long[startingSize];
        this.rebuildThreshold_ = QuickSelectSketch.setRebuildThreshold(this.hashTable_, this.nomEntries_);
        this.summaryTable_ = null;
    }

    QuickSelectSketch(QuickSelectSketch<S> sketch) {
        super(sketch.thetaLong_, sketch.empty_, sketch.summaryFactory_);
        this.nomEntries_ = sketch.nomEntries_;
        this.lgResizeFactor_ = sketch.lgResizeFactor_;
        this.samplingProbability_ = sketch.samplingProbability_;
        this.lgCurrentCapacity_ = sketch.lgCurrentCapacity_;
        this.retEntries_ = sketch.retEntries_;
        this.hashTable_ = (long[])sketch.hashTable_.clone();
        this.rebuildThreshold_ = sketch.rebuildThreshold_;
        this.summaryTable_ = Util.copySummaryArray(sketch.summaryTable_);
    }

    @Deprecated
    QuickSelectSketch(MemorySegment seg, SummaryDeserializer<S> deserializer, SummaryFactory<S> summaryFactory) {
        Validate val = new Validate();
        long thetaLong = val.validate(seg, deserializer);
        this.nomEntries_ = val.myNomEntries;
        this.lgResizeFactor_ = val.myLgResizeFactor;
        this.samplingProbability_ = val.mySamplingProbability;
        this.lgCurrentCapacity_ = val.myLgCurrentCapacity;
        this.retEntries_ = val.myRetEntries;
        this.rebuildThreshold_ = val.myRebuildThreshold;
        this.hashTable_ = val.myHashTable;
        this.summaryTable_ = (Summary[])val.mySummaryTable;
        super(thetaLong, val.myEmpty, summaryFactory);
    }

    QuickSelectSketch<S> copy() {
        return new QuickSelectSketch<S>(this);
    }

    long[] getHashTable() {
        return this.hashTable_;
    }

    @Override
    public int getRetainedEntries() {
        return this.retEntries_;
    }

    @Override
    public int getCountLessThanThetaLong(long thetaLong) {
        return HashOperations.count(this.hashTable_, thetaLong);
    }

    S[] getSummaryTable() {
        return this.summaryTable_;
    }

    public int getNominalEntries() {
        return this.nomEntries_;
    }

    public int getLgK() {
        return org.apache.datasketches.common.Util.exactLog2OfLong(this.nomEntries_);
    }

    public float getSamplingProbability() {
        return this.samplingProbability_;
    }

    public int getCurrentCapacity() {
        return 1 << this.lgCurrentCapacity_;
    }

    public ResizeFactor getResizeFactor() {
        return ResizeFactor.getRF(this.lgResizeFactor_);
    }

    public void trim() {
        if (this.retEntries_ > this.nomEntries_) {
            this.updateTheta();
            this.resize(this.hashTable_.length);
        }
    }

    public void reset() {
        this.empty_ = true;
        this.retEntries_ = 0;
        this.thetaLong_ = (long)(9.223372036854776E18 * (double)this.samplingProbability_);
        int startingCapacity = Util.getStartingCapacity(this.nomEntries_, this.lgResizeFactor_);
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(startingCapacity);
        this.hashTable_ = new long[startingCapacity];
        this.summaryTable_ = null;
        this.rebuildThreshold_ = QuickSelectSketch.setRebuildThreshold(this.hashTable_, this.nomEntries_);
    }

    @Override
    public CompactTupleSketch<S> compact() {
        if (this.getRetainedEntries() == 0) {
            if (this.empty_) {
                return new CompactTupleSketch(null, null, Long.MAX_VALUE, true);
            }
            return new CompactTupleSketch(null, null, this.thetaLong_, false);
        }
        long[] hashArr = new long[this.getRetainedEntries()];
        Summary[] summaryArr = Util.newSummaryArray(this.summaryTable_, (int)this.getRetainedEntries());
        int i = 0;
        for (int j = 0; j < this.hashTable_.length; ++j) {
            if (this.summaryTable_[j] == null) continue;
            hashArr[i] = this.hashTable_[j];
            summaryArr[i] = this.summaryTable_[j].copy();
            ++i;
        }
        return new CompactTupleSketch(hashArr, summaryArr, this.thetaLong_, this.empty_);
    }

    @Override
    @Deprecated
    public byte[] toByteArray() {
        boolean isThetaIncluded;
        byte[][] summariesBytes = null;
        int summariesBytesLength = 0;
        if (this.retEntries_ > 0) {
            summariesBytes = new byte[this.retEntries_][];
            int i = 0;
            for (int j = 0; j < this.summaryTable_.length; ++j) {
                if (this.summaryTable_[j] == null) continue;
                summariesBytes[i] = this.summaryTable_[j].toByteArray();
                summariesBytesLength += summariesBytes[i].length;
                ++i;
            }
        }
        int sizeBytes = 8;
        if (this.isInSamplingMode()) {
            sizeBytes += 4;
        }
        boolean bl = this.isInSamplingMode() ? (float)this.thetaLong_ < this.samplingProbability_ : (isThetaIncluded = this.thetaLong_ < Long.MAX_VALUE);
        if (isThetaIncluded) {
            sizeBytes += 8;
        }
        if (this.retEntries_ > 0) {
            sizeBytes += 4;
        }
        byte[] bytes = new byte[sizeBytes += 8 * this.retEntries_ + summariesBytesLength];
        int offset = 0;
        bytes[offset++] = 1;
        bytes[offset++] = 2;
        bytes[offset++] = (byte)Family.TUPLE.getID();
        bytes[offset++] = (byte)SerializerDeserializer.SketchType.QuickSelectSketch.ordinal();
        bytes[offset++] = (byte)((this.isInSamplingMode() ? 1 << Flags.IS_IN_SAMPLING_MODE.ordinal() : 0) | (this.empty_ ? 1 << Flags.IS_EMPTY.ordinal() : 0) | (this.retEntries_ > 0 ? 1 << Flags.HAS_ENTRIES.ordinal() : 0) | (isThetaIncluded ? 1 << Flags.IS_THETA_INCLUDED.ordinal() : 0));
        bytes[offset++] = (byte)Integer.numberOfTrailingZeros(this.nomEntries_);
        bytes[offset++] = (byte)this.lgCurrentCapacity_;
        bytes[offset++] = (byte)this.lgResizeFactor_;
        if (this.samplingProbability_ < 1.0f) {
            ByteArrayUtil.putFloatLE(bytes, offset, this.samplingProbability_);
            offset += 4;
        }
        if (isThetaIncluded) {
            ByteArrayUtil.putLongLE(bytes, offset, this.thetaLong_);
            offset += 8;
        }
        if (this.retEntries_ > 0) {
            ByteArrayUtil.putIntLE(bytes, offset, this.retEntries_);
            offset += 4;
        }
        if (this.retEntries_ > 0) {
            int i = 0;
            for (int j = 0; j < this.hashTable_.length; ++j) {
                if (this.summaryTable_[j] == null) continue;
                ByteArrayUtil.putLongLE(bytes, offset, this.hashTable_[j]);
                System.arraycopy(summariesBytes[i], 0, bytes, offset += 8, summariesBytes[i].length);
                offset += summariesBytes[i].length;
                ++i;
            }
        }
        return bytes;
    }

    void merge(long hash, S summary, SummarySetOperations<S> summarySetOps) {
        this.empty_ = false;
        if (hash > 0L && hash < this.thetaLong_) {
            int index = this.findOrInsert(hash);
            if (index < 0) {
                this.insertSummary(~index, summary.copy());
            } else {
                this.insertSummary(index, summarySetOps.union((Summary)this.summaryTable_[index], summary.copy()));
            }
            this.rebuildIfNeeded();
        }
    }

    boolean isInSamplingMode() {
        return this.samplingProbability_ < 1.0f;
    }

    void setThetaLong(long theta) {
        this.thetaLong_ = theta;
    }

    void setEmpty(boolean value) {
        this.empty_ = value;
    }

    int findOrInsert(long hash) {
        int index = HashOperations.hashSearchOrInsert(this.hashTable_, this.lgCurrentCapacity_, hash);
        if (index < 0) {
            ++this.retEntries_;
        }
        return index;
    }

    boolean rebuildIfNeeded() {
        if (this.retEntries_ <= this.rebuildThreshold_) {
            return false;
        }
        if (this.hashTable_.length > this.nomEntries_) {
            this.updateTheta();
            this.rebuild();
        } else {
            this.resize(this.hashTable_.length * (1 << this.lgResizeFactor_));
        }
        return true;
    }

    void rebuild() {
        this.resize(this.hashTable_.length);
    }

    void insert(long hash, S summary) {
        int index = HashOperations.hashInsertOnly(this.hashTable_, this.lgCurrentCapacity_, hash);
        this.insertSummary(index, summary);
        ++this.retEntries_;
        this.empty_ = false;
    }

    private void updateTheta() {
        long[] hashArr = new long[this.retEntries_];
        int i = 0;
        for (int j = 0; j < this.hashTable_.length; ++j) {
            if (this.summaryTable_[j] == null) continue;
            hashArr[i++] = this.hashTable_[j];
        }
        this.thetaLong_ = QuickSelect.select(hashArr, 0, this.retEntries_ - 1, this.nomEntries_);
    }

    private void resize(int newSize) {
        long[] oldHashTable = this.hashTable_;
        S[] oldSummaryTable = this.summaryTable_;
        this.hashTable_ = new long[newSize];
        this.summaryTable_ = Util.newSummaryArray(this.summaryTable_, (int)newSize);
        this.lgCurrentCapacity_ = Integer.numberOfTrailingZeros(newSize);
        this.retEntries_ = 0;
        for (int i = 0; i < oldHashTable.length; ++i) {
            if (oldSummaryTable[i] == null || oldHashTable[i] >= this.thetaLong_) continue;
            this.insert(oldHashTable[i], oldSummaryTable[i]);
        }
        this.rebuildThreshold_ = QuickSelectSketch.setRebuildThreshold(this.hashTable_, this.nomEntries_);
    }

    private static int setRebuildThreshold(long[] hashTable, int nomEntries) {
        if (hashTable.length > nomEntries) {
            return (int)((double)hashTable.length * 0.9375);
        }
        return (int)((double)hashTable.length * 0.5);
    }

    protected void insertSummary(int index, S summary) {
        if (this.summaryTable_ == null) {
            this.summaryTable_ = (Summary[])Array.newInstance(summary.getClass(), this.hashTable_.length);
        }
        this.summaryTable_[index] = summary;
    }

    @Override
    public TupleSketchIterator<S> iterator() {
        return new TupleSketchIterator(this.hashTable_, this.summaryTable_);
    }

    private static final class Validate<S> {
        long myThetaLong;
        boolean myEmpty;
        int myNomEntries;
        int myLgResizeFactor;
        float mySamplingProbability;
        int myLgCurrentCapacity;
        int myRetEntries;
        int myRebuildThreshold;
        long[] myHashTable;
        S[] mySummaryTable;

        private Validate() {
        }

        long validate(MemorySegment seg, SummaryDeserializer<?> deserializer) {
            boolean hasEntries;
            boolean isThetaIncluded;
            Objects.requireNonNull(seg, "Source MemorySegment must not be null.");
            Objects.requireNonNull(deserializer, "Deserializer must not be null.");
            org.apache.datasketches.common.Util.checkBounds(0L, 8L, seg.byteSize());
            int offset = 0;
            byte preambleLongs = seg.get(ValueLayout.JAVA_BYTE, (long)offset++);
            byte version = seg.get(ValueLayout.JAVA_BYTE, (long)offset++);
            byte familyId = seg.get(ValueLayout.JAVA_BYTE, (long)offset++);
            SerializerDeserializer.validateFamily(familyId, preambleLongs);
            if (version > 2) {
                throw new SketchesArgumentException("Unsupported serial version. Expected: 2 or lower, actual: " + version);
            }
            SerializerDeserializer.validateType(seg.get(ValueLayout.JAVA_BYTE, (long)offset++), SerializerDeserializer.SketchType.QuickSelectSketch);
            byte flags = seg.get(ValueLayout.JAVA_BYTE, (long)offset++);
            this.myNomEntries = 1 << seg.get(ValueLayout.JAVA_BYTE, (long)offset++);
            this.myLgCurrentCapacity = seg.get(ValueLayout.JAVA_BYTE, (long)offset++);
            this.myLgResizeFactor = seg.get(ValueLayout.JAVA_BYTE, (long)offset++);
            org.apache.datasketches.common.Util.checkBounds(0L, (long)preambleLongs * 8L, seg.byteSize());
            boolean isInSamplingMode = (flags & 1 << Flags.IS_IN_SAMPLING_MODE.ordinal()) > 0;
            float f = this.mySamplingProbability = isInSamplingMode ? seg.get(ValueLayout.JAVA_FLOAT_UNALIGNED, (long)offset) : 1.0f;
            if (isInSamplingMode) {
                offset += 4;
            }
            boolean bl = isThetaIncluded = (flags & 1 << Flags.IS_THETA_INCLUDED.ordinal()) > 0;
            if (isThetaIncluded) {
                this.myThetaLong = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)offset);
                offset += 8;
            } else {
                this.myThetaLong = (long)(9.223372036854776E18 * (double)this.mySamplingProbability);
            }
            int count = 0;
            boolean bl2 = hasEntries = (flags & 1 << Flags.HAS_ENTRIES.ordinal()) > 0;
            if (hasEntries) {
                count = seg.get(ValueLayout.JAVA_INT_UNALIGNED, (long)offset);
                offset += 4;
            }
            int currentCapacity = 1 << this.myLgCurrentCapacity;
            this.myHashTable = new long[currentCapacity];
            for (int i = 0; i < count; ++i) {
                long hash = seg.get(ValueLayout.JAVA_LONG_UNALIGNED, (long)offset);
                MemorySegment segRegion = seg.asSlice((long)(offset += 8), seg.byteSize() - (long)offset);
                DeserializeResult<?> summaryResult = deserializer.heapifySummary(segRegion);
                Object summary = summaryResult.getObject();
                offset += summaryResult.getSize();
                int index = HashOperations.hashInsertOnly(this.myHashTable, this.myLgCurrentCapacity, hash);
                if (this.mySummaryTable == null) {
                    this.mySummaryTable = (Object[])Array.newInstance(summary.getClass(), this.myHashTable.length);
                }
                this.mySummaryTable[index] = summary;
                ++this.myRetEntries;
                this.myEmpty = false;
            }
            this.myEmpty = (flags & 1 << Flags.IS_EMPTY.ordinal()) > 0;
            this.myRebuildThreshold = QuickSelectSketch.setRebuildThreshold(this.myHashTable, this.myNomEntries);
            return this.myThetaLong;
        }
    }

    private static enum Flags {
        IS_RESERVED,
        IS_IN_SAMPLING_MODE,
        IS_EMPTY,
        HAS_ENTRIES,
        IS_THETA_INCLUDED;

    }
}

