/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.theta;

import java.lang.foreign.MemorySegment;
import org.apache.datasketches.theta.CompactThetaSketch;
import org.apache.datasketches.theta.DirectCompactSketch;
import org.apache.datasketches.theta.EmptyCompactSketch;
import org.apache.datasketches.theta.ThetaAnotB;
import org.apache.datasketches.theta.ThetaIntersection;
import org.apache.datasketches.theta.ThetaSetOperation;
import org.apache.datasketches.theta.ThetaSketch;
import org.apache.datasketches.theta.UpdatableThetaSketch;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EmptyTest {
    @Test
    public void checkEmpty() {
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().build();
        UpdatableThetaSketch sk2 = UpdatableThetaSketch.builder().build();
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        int u = 100;
        for (int i = 0; i < 100; ++i) {
            sk1.update((long)i);
            sk2.update((long)(i + 100));
        }
        inter.intersect((ThetaSketch)sk1);
        inter.intersect((ThetaSketch)sk2);
        CompactThetaSketch csk = inter.getResult();
        EmptyTest.println(csk.toString());
        Assert.assertTrue((boolean)csk.isEmpty());
        ThetaAnotB aNotB = ThetaSetOperation.builder().buildANotB();
        CompactThetaSketch csk2 = aNotB.aNotB((ThetaSketch)csk, (ThetaSketch)sk1);
        Assert.assertTrue((boolean)csk2.isEmpty());
    }

    @Test
    public void checkNotEmpty() {
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().build();
        UpdatableThetaSketch sk2 = UpdatableThetaSketch.builder().build();
        ThetaIntersection inter = ThetaSetOperation.builder().buildIntersection();
        int u = 10000;
        for (int i = 0; i < 10000; ++i) {
            sk1.update((long)i);
            sk2.update((long)(i + 10000));
        }
        inter.intersect((ThetaSketch)sk1);
        inter.intersect((ThetaSketch)sk2);
        CompactThetaSketch csk = inter.getResult();
        EmptyTest.println(csk.toString());
        Assert.assertFalse((boolean)csk.isEmpty());
        ThetaAnotB aNotB = ThetaSetOperation.builder().buildANotB();
        CompactThetaSketch csk2 = aNotB.aNotB((ThetaSketch)csk, (ThetaSketch)sk1);
        EmptyTest.println(csk2.toString());
        Assert.assertFalse((boolean)csk2.isEmpty());
        UpdatableThetaSketch sk3 = UpdatableThetaSketch.builder().build();
        aNotB = ThetaSetOperation.builder().buildANotB();
        CompactThetaSketch csk3 = aNotB.aNotB((ThetaSketch)sk3, (ThetaSketch)sk1);
        EmptyTest.println(csk3.toString());
        Assert.assertTrue((boolean)csk3.isEmpty());
    }

    @Test
    public void checkPsampling() {
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().setP(0.5f).build();
        Assert.assertTrue((boolean)sk1.isEmpty());
        Assert.assertEquals((int)sk1.compact().toByteArray().length, (int)8);
    }

    @Test
    public void checkEmptyToCompact() {
        UpdatableThetaSketch sk1 = UpdatableThetaSketch.builder().build();
        CompactThetaSketch csk = sk1.compact();
        Assert.assertTrue((boolean)(csk instanceof EmptyCompactSketch));
        CompactThetaSketch csk2 = csk.compact();
        Assert.assertTrue((boolean)(csk2 instanceof EmptyCompactSketch));
        CompactThetaSketch csk3 = csk.compact(true, MemorySegment.ofArray(new byte[8]));
        Assert.assertTrue((boolean)(csk3 instanceof DirectCompactSketch));
        Assert.assertEquals((int)csk2.getCurrentPreambleLongs(), (int)1);
    }

    static void println(String s) {
    }
}

