/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.core;

import java.io.ByteArrayInputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.json.JsonArray;
import org.apache.activemq.artemis.json.JsonArrayBuilder;
import org.apache.activemq.artemis.json.JsonNumber;
import org.apache.activemq.artemis.json.JsonObject;
import org.apache.activemq.artemis.json.JsonObjectBuilder;
import org.apache.activemq.artemis.json.JsonString;
import org.apache.activemq.artemis.json.JsonValue;
import org.apache.activemq.artemis.utils.Base64;
import org.apache.activemq.artemis.utils.JsonLoader;
import org.apache.activemq.artemis.utils.ObjectInputStreamWithClassLoader;
import org.apache.activemq.artemis.utils.StringEscapeUtils;

public final class JsonUtil {
    public static JsonArray toJSONArray(Object[] array) throws Exception {
        JsonArrayBuilder jsonArray = JsonLoader.createArrayBuilder();
        for (Object parameter : array) {
            JsonUtil.addToArray(parameter, jsonArray);
        }
        return jsonArray.build();
    }

    public static Object[] fromJsonArray(JsonArray jsonArray) throws Exception {
        Object[] array = new Object[jsonArray.size()];
        for (int i = 0; i < jsonArray.size(); ++i) {
            Object val = jsonArray.get(i);
            if (val instanceof JsonArray) {
                Object[] inner;
                JsonArray jsonArrayValue = (JsonArray)val;
                array[i] = inner = JsonUtil.fromJsonArray(jsonArrayValue);
                continue;
            }
            if (val instanceof JsonObject) {
                JsonObject jsonObject = (JsonObject)val;
                HashMap<String, Object[]> map = new HashMap<String, Object[]>();
                Set keys = jsonObject.keySet();
                for (String key : keys) {
                    Object innerVal = jsonObject.get((Object)key);
                    if (innerVal instanceof JsonArray) {
                        JsonArray jsonArrayValue = (JsonArray)innerVal;
                        innerVal = JsonUtil.fromJsonArray(jsonArrayValue);
                    } else if (innerVal instanceof JsonString) {
                        JsonString jsonString = (JsonString)innerVal;
                        innerVal = jsonString.getString();
                    } else if (innerVal == JsonValue.FALSE) {
                        innerVal = Boolean.FALSE;
                    } else if (innerVal == JsonValue.TRUE) {
                        innerVal = Boolean.TRUE;
                    } else if (innerVal instanceof JsonNumber) {
                        JsonNumber jsonNumber = (JsonNumber)innerVal;
                        innerVal = jsonNumber.isIntegral() ? (Number)jsonNumber.longValue() : (Number)jsonNumber.doubleValue();
                    } else if (innerVal instanceof JsonObject) {
                        JsonObject innerJsonObject = (JsonObject)innerVal;
                        HashMap<String, Object> innerMap = new HashMap<String, Object>();
                        Set innerKeys = innerJsonObject.keySet();
                        for (String k : innerKeys) {
                            innerMap.put(k, innerJsonObject.get((Object)k));
                        }
                        innerVal = innerMap;
                    }
                    if (CompositeData.class.getName().equals(key)) {
                        Object data = innerVal;
                        CompositeData[] cds = new CompositeData[((Object[])data).length];
                        for (int i1 = 0; i1 < ((Object[])data).length; ++i1) {
                            String dataConverted = JsonUtil.convertJsonValue(data[i1], String.class).toString();
                            try (ObjectInputStreamWithClassLoader ois = new ObjectInputStreamWithClassLoader(new ByteArrayInputStream(Base64.decode((String)dataConverted)));){
                                ois.setAllowList("java.util,java.lang,javax.management");
                                cds[i1] = (CompositeDataSupport)ois.readObject();
                                continue;
                            }
                        }
                        innerVal = cds;
                    }
                    map.put(key, (Object[])innerVal);
                }
                array[i] = map;
                continue;
            }
            if (val instanceof JsonString) {
                JsonString jsonString = (JsonString)val;
                array[i] = jsonString.getString();
                continue;
            }
            if (val == JsonValue.FALSE) {
                array[i] = Boolean.FALSE;
                continue;
            }
            if (val == JsonValue.TRUE) {
                array[i] = Boolean.TRUE;
                continue;
            }
            if (val instanceof JsonNumber) {
                JsonNumber jsonNumber = (JsonNumber)val;
                if (jsonNumber.isIntegral()) {
                    array[i] = jsonNumber.longValue();
                    continue;
                }
                array[i] = jsonNumber.doubleValue();
                continue;
            }
            array[i] = val == JsonValue.NULL ? null : val;
        }
        return array;
    }

    public static JsonValue nullSafe(String input) {
        return new NullableJsonString(input);
    }

    public static void addToObject(String key, Object param, JsonObjectBuilder jsonObjectBuilder) {
        if (param instanceof Integer) {
            Integer integer = (Integer)param;
            jsonObjectBuilder.add(key, integer.intValue());
        } else if (param instanceof Long) {
            Long longValue = (Long)param;
            jsonObjectBuilder.add(key, longValue.longValue());
        } else if (param instanceof Double) {
            Double doubleValue = (Double)param;
            jsonObjectBuilder.add(key, doubleValue.doubleValue());
        } else if (param instanceof String) {
            String string = (String)param;
            jsonObjectBuilder.add(key, string);
        } else if (param instanceof Boolean) {
            Boolean booleanValue = (Boolean)param;
            jsonObjectBuilder.add(key, booleanValue.booleanValue());
        } else if (param instanceof Map) {
            Map map = (Map)param;
            jsonObjectBuilder.add(key, (JsonValue)JsonUtil.toJsonObject(map));
        } else if (param instanceof Short) {
            Short shortValue = (Short)param;
            jsonObjectBuilder.add(key, (int)shortValue.shortValue());
        } else if (param instanceof Byte) {
            Byte byteValue = (Byte)param;
            jsonObjectBuilder.add(key, (int)byteValue.shortValue());
        } else if (param instanceof Number) {
            Number number = (Number)param;
            jsonObjectBuilder.add(key, number.doubleValue());
        } else if (param instanceof SimpleString) {
            jsonObjectBuilder.add(key, param.toString());
        } else if (param == null) {
            jsonObjectBuilder.addNull(key);
        } else if (param instanceof byte[]) {
            byte[] bytes = (byte[])param;
            JsonArrayBuilder byteArrayObject = JsonUtil.toJsonArrayBuilder(bytes);
            jsonObjectBuilder.add(key, byteArrayObject);
        } else if (param instanceof Object[]) {
            Object[] objects = (Object[])param;
            JsonArrayBuilder objectArrayBuilder = JsonLoader.createArrayBuilder();
            for (Object parameter : objects) {
                JsonUtil.addToArray(parameter, objectArrayBuilder);
            }
            jsonObjectBuilder.add(key, objectArrayBuilder);
        } else if (param instanceof JsonValue) {
            JsonValue jsonValue = (JsonValue)param;
            jsonObjectBuilder.add(key, jsonValue);
        } else {
            jsonObjectBuilder.add(key, param.toString());
        }
    }

    public static void addToArray(Object param, JsonArrayBuilder jsonArrayBuilder) {
        if (param instanceof Integer) {
            Integer integer = (Integer)param;
            jsonArrayBuilder.add(integer.intValue());
        } else if (param instanceof Long) {
            Long longValue = (Long)param;
            jsonArrayBuilder.add(longValue.longValue());
        } else if (param instanceof Double) {
            Double doubleValue = (Double)param;
            jsonArrayBuilder.add(doubleValue.doubleValue());
        } else if (param instanceof String) {
            String string = (String)param;
            jsonArrayBuilder.add(string);
        } else if (param instanceof Boolean) {
            Boolean booleanValue = (Boolean)param;
            jsonArrayBuilder.add(booleanValue.booleanValue());
        } else if (param instanceof Map) {
            Map map = (Map)param;
            jsonArrayBuilder.add((JsonValue)JsonUtil.toJsonObject(map));
        } else if (param instanceof Short) {
            Short shortValue = (Short)param;
            jsonArrayBuilder.add((int)shortValue.shortValue());
        } else if (param instanceof Byte) {
            Byte byteValue = (Byte)param;
            jsonArrayBuilder.add((int)byteValue.shortValue());
        } else if (param instanceof Number) {
            Number number = (Number)param;
            jsonArrayBuilder.add(number.doubleValue());
        } else if (param == null) {
            jsonArrayBuilder.addNull();
        } else if (param instanceof byte[]) {
            byte[] bytes = (byte[])param;
            JsonArrayBuilder byteArrayObject = JsonUtil.toJsonArrayBuilder(bytes);
            jsonArrayBuilder.add(byteArrayObject);
        } else if (param instanceof CompositeData[]) {
            CompositeData[] compositeData = (CompositeData[])param;
            JsonArrayBuilder innerJsonArray = JsonLoader.createArrayBuilder();
            for (CompositeData data : compositeData) {
                String s = Base64.encodeObject((Serializable)((CompositeDataSupport)data));
                innerJsonArray.add(s);
            }
            JsonObjectBuilder jsonObject = JsonLoader.createObjectBuilder();
            jsonObject.add(CompositeData.class.getName(), innerJsonArray);
            jsonArrayBuilder.add(jsonObject);
        } else if (param instanceof Object[]) {
            Object[] objects = (Object[])param;
            JsonArrayBuilder objectArrayBuilder = JsonLoader.createArrayBuilder();
            for (Object parameter : objects) {
                JsonUtil.addToArray(parameter, objectArrayBuilder);
            }
            jsonArrayBuilder.add(objectArrayBuilder);
        } else if (param instanceof JsonValue) {
            JsonValue jsonValue = (JsonValue)param;
            jsonArrayBuilder.add(jsonValue);
        } else {
            jsonArrayBuilder.add(param.toString());
        }
    }

    public static JsonArray toJsonArray(List<String> strings) {
        JsonArrayBuilder array = JsonLoader.createArrayBuilder();
        if (strings != null) {
            for (String connector : strings) {
                array.add(connector);
            }
        }
        return array.build();
    }

    public static JsonObject toJsonObject(Map<String, ?> map) {
        JsonObjectBuilder jsonObjectBuilder = JsonLoader.createObjectBuilder();
        if (map != null) {
            for (Map.Entry<String, ?> entry : map.entrySet()) {
                JsonUtil.addToObject(String.valueOf(entry.getKey()), entry.getValue(), jsonObjectBuilder);
            }
        }
        return jsonObjectBuilder.build();
    }

    public static JsonArrayBuilder toJsonArrayBuilder(byte[] byteArray) {
        JsonArrayBuilder jsonArrayBuilder = JsonLoader.createArrayBuilder();
        if (byteArray != null) {
            for (int i = 0; i < byteArray.length; ++i) {
                jsonArrayBuilder.add((int)Byte.valueOf(byteArray[i]).shortValue());
            }
        }
        return jsonArrayBuilder;
    }

    public static JsonArray readJsonArray(String jsonString) {
        return JsonLoader.readArray((Reader)new StringReader(jsonString));
    }

    public static JsonObject readJsonObject(String jsonString) {
        return JsonLoader.readObject((Reader)new StringReader(jsonString));
    }

    public static Map<String, String> readJsonProperties(String jsonString) {
        HashMap<String, String> properties = new HashMap<String, String>();
        if (jsonString != null) {
            JsonUtil.readJsonObject(jsonString).entrySet().forEach(e -> properties.put((String)e.getKey(), ((JsonValue)e.getValue()).toString()));
        }
        return properties;
    }

    public static Object convertJsonValue(Object jsonValue, Class desiredType) {
        if (jsonValue instanceof JsonNumber) {
            JsonNumber number = (JsonNumber)jsonValue;
            if (desiredType == null || desiredType == Long.class || desiredType == Long.TYPE) {
                return number.longValue();
            }
            if (desiredType == Integer.class || desiredType == Integer.TYPE) {
                return number.intValue();
            }
            if (desiredType == Double.class || desiredType == Double.TYPE) {
                return number.doubleValue();
            }
            return number.longValue();
        }
        if (jsonValue instanceof JsonString) {
            JsonString jsonString = (JsonString)jsonValue;
            return jsonString.getString();
        }
        if (jsonValue instanceof JsonValue) {
            if (jsonValue == JsonValue.TRUE) {
                return true;
            }
            if (jsonValue == JsonValue.FALSE) {
                return false;
            }
            return jsonValue.toString();
        }
        if (jsonValue instanceof Number) {
            Number jsonNumber = (Number)jsonValue;
            if (desiredType == Integer.TYPE || desiredType == Integer.class) {
                return jsonNumber.intValue();
            }
            if (desiredType == Long.TYPE || desiredType == Long.class) {
                return jsonNumber.longValue();
            }
            if (desiredType == Double.TYPE || desiredType == Double.class) {
                return jsonNumber.doubleValue();
            }
            if (desiredType == Short.TYPE || desiredType == Short.class) {
                return jsonNumber.shortValue();
            }
            return jsonValue;
        }
        if (jsonValue instanceof Object[]) {
            Object[] objects = (Object[])jsonValue;
            Object[] result = desiredType != null ? (Object[])Array.newInstance(desiredType, objects.length) : objects;
            for (int i = 0; i < objects.length; ++i) {
                result[i] = JsonUtil.convertJsonValue(objects[i], desiredType);
            }
            return result;
        }
        return jsonValue;
    }

    private JsonUtil() {
    }

    public static String truncateString(String str, int valueSizeLimit) {
        if (valueSizeLimit >= 0 && str.length() > valueSizeLimit) {
            return new StringBuilder(valueSizeLimit + 32).append(str.substring(0, valueSizeLimit)).append(", + ").append(str.length() - valueSizeLimit).append(" more").toString();
        }
        return str;
    }

    public static Object truncate(Object value, int valueSizeLimit) {
        if (value == null) {
            return "";
        }
        Object result = value;
        if (valueSizeLimit >= 0) {
            if (String.class.equals(value.getClass())) {
                result = JsonUtil.truncateString((String)value, valueSizeLimit);
            } else if (value.getClass().isArray()) {
                if (byte[].class.equals(value.getClass())) {
                    if (((byte[])value).length > valueSizeLimit) {
                        result = Arrays.copyOfRange((byte[])value, 0, valueSizeLimit);
                    }
                } else if (char[].class.equals(value.getClass()) && ((char[])value).length > valueSizeLimit) {
                    result = Arrays.copyOfRange((char[])value, 0, valueSizeLimit);
                }
            }
        }
        return result;
    }

    public static JsonObject mergeAndUpdate(JsonObject source, JsonObject update) {
        JsonObjectBuilder jsonObjectBuilder = JsonLoader.createObjectBuilder();
        for (Map.Entry entry : source.entrySet()) {
            jsonObjectBuilder.add((String)entry.getKey(), (JsonValue)entry.getValue());
        }
        for (String updateKey : update.keySet()) {
            JsonValue updatedValue = (JsonValue)update.get((Object)updateKey);
            if (updatedValue == null) continue;
            if (!source.containsKey((Object)updateKey)) {
                jsonObjectBuilder.add(updateKey, updatedValue);
                continue;
            }
            if (updatedValue.getValueType() == JsonValue.ValueType.OBJECT) {
                jsonObjectBuilder.add(updateKey, (JsonValue)JsonUtil.mergeAndUpdate(source.getJsonObject(updateKey), updatedValue.asJsonObject()));
                continue;
            }
            if (updatedValue.getValueType() == JsonValue.ValueType.ARRAY) {
                JsonArrayBuilder jsonArrayBuilder = JsonLoader.createArrayBuilder();
                JsonArray updatedArrayValue = update.getJsonArray(updateKey);
                JsonArray sourceArrayValue = source.getJsonArray(updateKey);
                for (int i = 0; i < updatedArrayValue.size(); ++i) {
                    if (i < sourceArrayValue.size()) {
                        JsonValue element = (JsonValue)updatedArrayValue.get(i);
                        if (element.getValueType() == JsonValue.ValueType.OBJECT) {
                            jsonArrayBuilder.add((JsonValue)JsonUtil.mergeAndUpdate(sourceArrayValue.getJsonObject(i), updatedArrayValue.getJsonObject(i)));
                            continue;
                        }
                        jsonArrayBuilder.add(element);
                        continue;
                    }
                    jsonArrayBuilder.add((JsonValue)updatedArrayValue.get(i));
                }
                jsonObjectBuilder.add(updateKey, (JsonValue)jsonArrayBuilder.build());
                continue;
            }
            jsonObjectBuilder.add(updateKey, updatedValue);
        }
        return jsonObjectBuilder.build();
    }

    public static JsonObjectBuilder objectBuilderWithValueAtPath(String componentPath, JsonValue componentStatus) {
        JsonObjectBuilder jsonObjectBuilder = JsonLoader.createObjectBuilder();
        String[] nestedComponents = componentPath.split("/", 0);
        for (int i = nestedComponents.length - 1; i > 0; --i) {
            JsonObjectBuilder nestedBuilder = JsonLoader.createObjectBuilder();
            nestedBuilder.add(nestedComponents[i], componentStatus);
            componentStatus = nestedBuilder.build();
        }
        jsonObjectBuilder.add(nestedComponents[0], componentStatus);
        return jsonObjectBuilder;
    }

    public static String arrayToString(JsonObject jsonObject, String key) {
        JsonValue value = (JsonValue)jsonObject.get((Object)key);
        if (value == null || value.getValueType() != JsonValue.ValueType.ARRAY) {
            return "";
        }
        return jsonObject.getJsonArray(key).stream().map(s -> ((JsonString)s).getString()).collect(Collectors.joining(", "));
    }

    private static class NullableJsonString
    implements JsonValue,
    JsonString {
        private final String value;
        private String escape;

        NullableJsonString(String value) {
            this.value = value == null || value.isEmpty() ? null : value;
        }

        public JsonValue.ValueType getValueType() {
            return this.value == null ? JsonValue.ValueType.NULL : JsonValue.ValueType.STRING;
        }

        public String getString() {
            return this.value;
        }

        public CharSequence getChars() {
            return this.getString();
        }

        public String toString() {
            if (this.value == null) {
                return null;
            }
            Object s = this.escape;
            if (s == null) {
                this.escape = s = "\"" + StringEscapeUtils.escapeString((String)this.value) + "\"";
            }
            return s;
        }
    }
}

