/*
 * Decompiled with CFR 0.152.
 */
package org.mozilla.javascript;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessControlContext;
import java.security.AllPermission;
import java.security.Permission;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.mozilla.javascript.BeanProperty;
import org.mozilla.javascript.ClassCache;
import org.mozilla.javascript.ClassShutter;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.ContextFactory;
import org.mozilla.javascript.FieldAndMethods;
import org.mozilla.javascript.JavaMembers_jdk11;
import org.mozilla.javascript.Kit;
import org.mozilla.javascript.MemberBox;
import org.mozilla.javascript.NativeJavaConstructor;
import org.mozilla.javascript.NativeJavaMethod;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.ScriptRuntime;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.mozilla.javascript.lc.member.NativeJavaField;
import org.mozilla.javascript.lc.type.TypeInfo;
import org.mozilla.javascript.lc.type.TypeInfoFactory;

class JavaMembers {
    private static final boolean STRICT_REFLECTIVE_ACCESS = JavaMembers.isModularJava();
    private static final Permission allPermission = new AllPermission();
    private Class<?> cl;
    private Map<String, Object> members;
    private Map<String, FieldAndMethods> fieldAndMethods;
    private Map<String, Object> staticMembers;
    private Map<String, FieldAndMethods> staticFieldAndMethods;
    NativeJavaMethod ctors;

    JavaMembers(Scriptable scope, Class<?> cl) {
        this(scope, cl, false);
    }

    JavaMembers(Scriptable scope, Class<?> cl, boolean includeProtected) {
        try (Context cx = ContextFactory.getGlobal().enterContext();){
            ClassShutter shutter = cx.getClassShutter();
            if (shutter != null && !shutter.visibleToScripts(cl.getName())) {
                throw Context.reportRuntimeErrorById("msg.access.prohibited", cl.getName());
            }
            this.members = new HashMap<String, Object>();
            this.staticMembers = new HashMap<String, Object>();
            this.cl = cl;
            boolean includePrivate = cx.hasFeature(13);
            this.reflect(cx, scope, includeProtected, includePrivate);
        }
    }

    private static boolean isModularJava() {
        try {
            Class.class.getMethod("getModule", new Class[0]);
            return true;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    boolean has(String name, boolean isStatic) {
        Map<String, Object> ht = isStatic ? this.staticMembers : this.members;
        Object obj = ht.get(name);
        if (obj != null) {
            return true;
        }
        return this.findExplicitFunction(name, isStatic) != null;
    }

    Object get(Scriptable scope, String name, Object javaObject, boolean isStatic) {
        Object got;
        Map<String, Object> ht = isStatic ? this.staticMembers : this.members;
        Object member = ht.get(name);
        if (!isStatic && member == null) {
            member = this.staticMembers.get(name);
        }
        if (member == null && (member = this.getExplicitFunction(scope, name, javaObject, isStatic)) == null) {
            return Scriptable.NOT_FOUND;
        }
        if (member instanceof Scriptable) {
            return member;
        }
        Context cx = Context.getContext();
        if (member instanceof BeanProperty) {
            BeanProperty bean = (BeanProperty)member;
            if (bean.getter == null) {
                return Scriptable.NOT_FOUND;
            }
            return bean.getter.call(cx, scope, scope, ScriptRuntime.emptyArgs);
        }
        NativeJavaField field = (NativeJavaField)member;
        try {
            got = field.get(isStatic ? null : javaObject);
        }
        catch (Exception ex) {
            throw Context.throwAsScriptRuntimeEx(ex);
        }
        TypeInfo type = field.type();
        if (scope instanceof NativeJavaObject) {
            type = TypeInfoFactory.GLOBAL.consolidateType(type, ((NativeJavaObject)scope).staticType);
        }
        return cx.getWrapFactory().wrap(cx, ScriptableObject.getTopLevelScope(scope), got, type);
    }

    void put(Scriptable scope, String name, Object javaObject, Object value, boolean isStatic) {
        Map<String, Object> ht = isStatic ? this.staticMembers : this.members;
        Object member = ht.get(name);
        if (!isStatic && member == null) {
            member = this.staticMembers.get(name);
        }
        if (member == null) {
            throw this.reportMemberNotFound(name);
        }
        if (member instanceof FieldAndMethods) {
            FieldAndMethods fam = (FieldAndMethods)ht.get(name);
            member = fam.field;
        }
        if (member instanceof BeanProperty) {
            BeanProperty bp = (BeanProperty)member;
            if (bp.setter == null) {
                throw this.reportMemberNotFound(name);
            }
            bp.setter.call(Context.getContext(), ScriptableObject.getTopLevelScope(scope), scope, new Object[]{value});
        } else if (member instanceof NativeJavaField) {
            NativeJavaField field = (NativeJavaField)member;
            TypeInfo type = field.type();
            if (scope instanceof NativeJavaObject) {
                type = TypeInfoFactory.GLOBAL.consolidateType(type, ((NativeJavaObject)scope).staticType);
            }
            try {
                field.set(javaObject, Context.jsToJava(value, type));
            }
            catch (IllegalAccessException accessEx) {
                throw Context.throwAsScriptRuntimeEx(accessEx);
            }
            catch (IllegalArgumentException argEx) {
                throw Context.reportRuntimeErrorById("msg.java.internal.field.type", value.getClass().getName(), field, javaObject.getClass().getName());
            }
        } else {
            String str = member == null ? "msg.java.internal.private" : "msg.java.method.assign";
            throw Context.reportRuntimeErrorById(str, name);
        }
    }

    Object[] getIds(boolean isStatic) {
        Map<String, Object> map = isStatic ? this.staticMembers : this.members;
        return map.keySet().toArray(new Object[0]);
    }

    static String javaSignature(Class<?> type) {
        if (!type.isArray()) {
            return type.getName();
        }
        int arrayDimension = 0;
        do {
            ++arrayDimension;
        } while ((type = type.getComponentType()).isArray());
        String name = type.getName();
        String suffix = "[]";
        if (arrayDimension == 1) {
            return name.concat(suffix);
        }
        int length = name.length() + arrayDimension * suffix.length();
        StringBuilder sb = new StringBuilder(length);
        sb.append(name);
        while (arrayDimension != 0) {
            --arrayDimension;
            sb.append(suffix);
        }
        return sb.toString();
    }

    static String liveConnectSignature(List<TypeInfo> argTypes) {
        if (argTypes.isEmpty()) {
            return "()";
        }
        StringBuilder builder = new StringBuilder();
        builder.append('(');
        Iterator<TypeInfo> iter = argTypes.iterator();
        if (iter.hasNext()) {
            builder.append(JavaMembers.javaSignature(iter.next().asClass()));
            while (iter.hasNext()) {
                builder.append(',').append(JavaMembers.javaSignature(iter.next().asClass()));
            }
        }
        builder.append(')');
        return builder.toString();
    }

    private MemberBox findExplicitFunction(String name, boolean isStatic) {
        boolean isCtor;
        int sigStart = name.indexOf(40);
        if (sigStart < 0) {
            return null;
        }
        Map<String, Object> ht = isStatic ? this.staticMembers : this.members;
        MemberBox[] methodsOrCtors = null;
        boolean bl = isCtor = isStatic && sigStart == 0;
        if (isCtor) {
            methodsOrCtors = this.ctors.methods;
        } else {
            String trueName = name.substring(0, sigStart);
            Object obj = ht.get(trueName);
            if (!isStatic && obj == null) {
                obj = this.staticMembers.get(trueName);
            }
            if (obj instanceof NativeJavaMethod) {
                NativeJavaMethod njm = (NativeJavaMethod)obj;
                methodsOrCtors = njm.methods;
            }
        }
        if (methodsOrCtors != null) {
            for (MemberBox methodsOrCtor : methodsOrCtors) {
                String sig = JavaMembers.liveConnectSignature(methodsOrCtor.getArgTypes());
                if (sigStart + sig.length() != name.length() || !name.regionMatches(sigStart, sig, 0, sig.length())) continue;
                return methodsOrCtor;
            }
        }
        return null;
    }

    private Object getExplicitFunction(Scriptable scope, String name, Object javaObject, boolean isStatic) {
        Map<String, Object> ht = isStatic ? this.staticMembers : this.members;
        Object member = null;
        MemberBox methodOrCtor = this.findExplicitFunction(name, isStatic);
        if (methodOrCtor != null) {
            Scriptable prototype = ScriptableObject.getFunctionPrototype(scope);
            if (methodOrCtor.isCtor()) {
                NativeJavaConstructor fun = new NativeJavaConstructor(methodOrCtor);
                fun.setPrototype(prototype);
                member = fun;
                ht.put(name, fun);
            } else {
                String trueName = methodOrCtor.getName();
                member = ht.get(trueName);
                if (member instanceof NativeJavaMethod && ((NativeJavaMethod)member).methods.length > 1) {
                    NativeJavaMethod fun = new NativeJavaMethod(methodOrCtor, name);
                    fun.setPrototype(prototype);
                    ht.put(name, fun);
                    member = fun;
                }
            }
        }
        return member;
    }

    private Method[] discoverAccessibleMethods(Class<?> clazz, boolean includeProtected, boolean includePrivate) {
        HashMap<MethodSignature, Method> map = new HashMap<MethodSignature, Method>();
        this.discoverAccessibleMethods(clazz, map, includeProtected, includePrivate);
        return map.values().toArray(new Method[0]);
    }

    private void discoverAccessibleMethods(Class<?> clazz, Map<MethodSignature, Method> map, boolean includeProtected, boolean includePrivate) {
        Class<?>[] interfaces;
        if (Modifier.isPublic(clazz.getModifiers()) || includePrivate) {
            try {
                if (includeProtected || includePrivate) {
                    while (clazz != null) {
                        try {
                            Class<?>[] interfaces2;
                            Method[] methods;
                            for (Method method : methods = clazz.getDeclaredMethods()) {
                                int mods = method.getModifiers();
                                if (!Modifier.isPublic(mods) && !Modifier.isProtected(mods) && !includePrivate) continue;
                                Method registered = JavaMembers.registerMethod(map, method);
                                if (!includePrivate || registered.isAccessible()) continue;
                                registered.setAccessible(true);
                            }
                            for (Class<?> intface : interfaces2 = clazz.getInterfaces()) {
                                this.discoverAccessibleMethods(intface, map, includeProtected, includePrivate);
                            }
                            clazz = clazz.getSuperclass();
                        }
                        catch (SecurityException e) {
                            this.discoverPublicMethods(clazz, map);
                            break;
                        }
                    }
                } else {
                    this.discoverPublicMethods(clazz, map);
                }
                return;
            }
            catch (SecurityException e) {
                Context.reportWarning("Could not discover accessible methods of class " + clazz.getName() + " due to lack of privileges, attemping superclasses/interfaces.");
            }
        }
        for (Class<?> intface : interfaces = clazz.getInterfaces()) {
            this.discoverAccessibleMethods(intface, map, includeProtected, includePrivate);
        }
        Class<?> superclass = clazz.getSuperclass();
        if (superclass != null) {
            this.discoverAccessibleMethods(superclass, map, includeProtected, includePrivate);
        }
    }

    void discoverPublicMethods(Class<?> clazz, Map<MethodSignature, Method> map) {
        Method[] methods;
        for (Method method : methods = clazz.getMethods()) {
            JavaMembers.registerMethod(map, method);
        }
    }

    static Method registerMethod(Map<MethodSignature, Method> map, Method method) {
        MethodSignature sig = new MethodSignature(method);
        return map.merge(sig, method, JavaMembers::getMoreConcreteMethod);
    }

    private static Method getMoreConcreteMethod(Method oldValue, Method newValue) {
        if (oldValue.getReturnType().equals(newValue.getReturnType())) {
            return oldValue;
        }
        if (oldValue.getReturnType().isAssignableFrom(newValue.getReturnType())) {
            return newValue;
        }
        return oldValue;
    }

    private void reflect(Context cx, Scriptable scope, boolean includeProtected, boolean includePrivate) {
        int isStatic;
        Method[] methods;
        TypeInfoFactory typeFactory = TypeInfoFactory.get(scope);
        for (Method method : methods = this.discoverAccessibleMethods(this.cl, includeProtected, includePrivate)) {
            ArrayList<Object> overloadedMethods;
            String name;
            int n = method.getModifiers();
            boolean isStatic2 = Modifier.isStatic(n);
            Map<String, Object> ht = isStatic2 ? this.staticMembers : this.members;
            Object value = ht.get(name = method.getName());
            if (value == null) {
                ht.put(name, method);
                continue;
            }
            if (value instanceof ArrayList) {
                overloadedMethods = (ArrayList<Object>)value;
            } else {
                if (!(value instanceof Method)) {
                    Kit.codeBug();
                }
                overloadedMethods = new ArrayList<Object>();
                overloadedMethods.add(value);
                ht.put(name, overloadedMethods);
            }
            overloadedMethods.add(method);
        }
        for (int tableCursor = 0; tableCursor != 2; ++tableCursor) {
            isStatic = tableCursor == 0 ? 1 : 0;
            Map<String, Object> ht = isStatic != 0 ? this.staticMembers : this.members;
            for (Map.Entry entry : ht.entrySet()) {
                MemberBox[] methodBoxes;
                Object value = entry.getValue();
                if (value instanceof Method) {
                    methodBoxes = new MemberBox[]{new MemberBox((Method)value, typeFactory, this.cl)};
                } else {
                    ArrayList overloadedMethods = (ArrayList)value;
                    int N = overloadedMethods.size();
                    if (N < 2) {
                        Kit.codeBug();
                    }
                    methodBoxes = new MemberBox[N];
                    for (int i = 0; i != N; ++i) {
                        Method method = (Method)overloadedMethods.get(i);
                        methodBoxes[i] = new MemberBox(method, typeFactory, this.cl);
                    }
                }
                NativeJavaMethod fun = new NativeJavaMethod(methodBoxes);
                if (scope != null) {
                    ScriptRuntime.setFunctionProtoAndParent(fun, cx, scope, false);
                }
                entry.setValue(fun);
            }
        }
        for (Field field : this.getAccessibleFields(includeProtected, includePrivate)) {
            String string = field.getName();
            int mods = field.getModifiers();
            try {
                boolean isStatic3 = Modifier.isStatic(mods);
                Map<String, Object> ht = isStatic3 ? this.staticMembers : this.members;
                Object member = ht.get(string);
                if (member == null) {
                    ht.put(string, new NativeJavaField(field, typeFactory));
                    continue;
                }
                if (member instanceof NativeJavaMethod) {
                    Map<String, FieldAndMethods> fmht;
                    NativeJavaMethod method = (NativeJavaMethod)member;
                    FieldAndMethods fam = new FieldAndMethods(scope, method.methods, new NativeJavaField(field, typeFactory));
                    Map<String, FieldAndMethods> map = fmht = isStatic3 ? this.staticFieldAndMethods : this.fieldAndMethods;
                    if (fmht == null) {
                        fmht = new HashMap<String, FieldAndMethods>();
                        if (isStatic3) {
                            this.staticFieldAndMethods = fmht;
                        } else {
                            this.fieldAndMethods = fmht;
                        }
                    }
                    fmht.put(string, fam);
                    ht.put(string, fam);
                    continue;
                }
                if (member instanceof NativeJavaField) {
                    NativeJavaField oldField = (NativeJavaField)member;
                    if (oldField.raw().getDeclaringClass().isAssignableFrom(field.getDeclaringClass())) {
                        ht.put(string, new NativeJavaField(field, typeFactory));
                    }
                    continue;
                }
                throw Kit.codeBug("unknown java member: " + String.valueOf(member));
            }
            catch (SecurityException e) {
                Context.reportWarning("Could not access field " + string + " of class " + this.cl.getName() + " due to lack of privileges.");
            }
        }
        for (int tableCursor = 0; tableCursor != 2; ++tableCursor) {
            isStatic = tableCursor == 0 ? 1 : 0;
            Map<String, Object> ht = isStatic != 0 ? this.staticMembers : this.members;
            ht.putAll(JavaMembers.extractBeaning(ht, isStatic != 0, includePrivate));
        }
        Constructor<?>[] constructors = this.getAccessibleConstructors(includePrivate);
        MemberBox[] ctorMembers = new MemberBox[constructors.length];
        for (int i = 0; i != constructors.length; ++i) {
            ctorMembers[i] = new MemberBox(constructors[i], typeFactory);
        }
        this.ctors = new NativeJavaMethod(ctorMembers, this.cl.getSimpleName());
    }

    private static boolean maskingExistedMember(boolean includePrivate, Map<String, Object> members, String beanName) {
        Object existed = members.get(beanName);
        if (existed == null) {
            return false;
        }
        if (existed instanceof NativeJavaField) {
            return !includePrivate || !Modifier.isPrivate(((NativeJavaField)existed).raw().getModifiers());
        }
        return true;
    }

    private static String getBeanName(String nameComponent) {
        char ch0 = nameComponent.charAt(0);
        if (Character.isUpperCase(ch0)) {
            if (nameComponent.length() == 1) {
                return nameComponent.toLowerCase(Locale.ROOT);
            }
            char ch1 = nameComponent.charAt(1);
            if (!Character.isUpperCase(ch1)) {
                return Character.toLowerCase(ch0) + nameComponent.substring(1);
            }
        }
        return nameComponent;
    }

    private static Map<String, BeanProperty> extractBeaning(Map<String, Object> members, boolean isStatic, boolean includePrivate) {
        HashMap<String, BeanProperty> beans = new HashMap<String, BeanProperty>();
        for (Map.Entry<String, Object> entry : members.entrySet()) {
            String beanName;
            String nameComponent;
            String name = entry.getKey();
            boolean isGetBeaning = name.startsWith("get");
            boolean isIsBeaning = name.startsWith("is");
            boolean isSetBeaning = name.startsWith("set");
            if (!isGetBeaning && !isIsBeaning && !isSetBeaning || (nameComponent = name.substring(isIsBeaning ? 2 : 3)).isEmpty() || !(entry.getValue() instanceof NativeJavaMethod) || JavaMembers.maskingExistedMember(includePrivate, members, beanName = JavaMembers.getBeanName(nameComponent))) continue;
            if (isGetBeaning || isIsBeaning) {
                NativeJavaMethod method = (NativeJavaMethod)entry.getValue();
                MemberBox candidate = JavaMembers.extractGetMethod(method.methods, isStatic);
                if (candidate == null) continue;
                BeanProperty bean = beans.computeIfAbsent(beanName, BeanProperty::new);
                if (bean.getter != null && !bean.getter.getFunctionName().startsWith("is")) continue;
                if (method.methods.length == 1) {
                    bean.getter = method;
                    continue;
                }
                bean.getter = new NativeJavaMethod(new MemberBox[]{candidate});
                continue;
            }
            BeanProperty bean = beans.computeIfAbsent(beanName, BeanProperty::new);
            bean.setter = (NativeJavaMethod)entry.getValue();
        }
        for (BeanProperty bean : beans.values()) {
            TypeInfo type;
            MemberBox match;
            NativeJavaMethod setterCandidates = bean.setter;
            if (setterCandidates == null) continue;
            NativeJavaMethod getter = bean.getter;
            if (getter != null && (match = JavaMembers.extractSetMethod(type = getter.methods[0].getReturnType(), setterCandidates.methods, isStatic)) != null) {
                bean.setter = new NativeJavaMethod(match, match.getName());
                continue;
            }
            match = JavaMembers.extractSetMethod(setterCandidates.methods, isStatic);
            if (match != null) continue;
            bean.setter = null;
        }
        return beans;
    }

    private Constructor<?>[] getAccessibleConstructors(boolean includePrivate) {
        if (includePrivate && this.cl != ScriptRuntime.ClassClass) {
            try {
                AccessibleObject[] cons = this.cl.getDeclaredConstructors();
                AccessibleObject.setAccessible(cons, true);
                return cons;
            }
            catch (SecurityException e) {
                Context.reportWarning("Could not access constructor  of class " + this.cl.getName() + " due to lack of privileges.");
            }
        }
        return this.cl.getConstructors();
    }

    private Field[] getAccessibleFields(boolean includeProtected, boolean includePrivate) {
        if (includePrivate || includeProtected) {
            try {
                ArrayList<Field> fieldsList = new ArrayList<Field>();
                for (Class<?> c = this.cl; c != null; c = c.getSuperclass()) {
                    for (Field field : c.getDeclaredFields()) {
                        int mod = field.getModifiers();
                        if (!includePrivate && !Modifier.isPublic(mod) && !Modifier.isProtected(mod)) continue;
                        if (!field.isAccessible()) {
                            field.setAccessible(true);
                        }
                        fieldsList.add(field);
                    }
                }
                return fieldsList.toArray(new Field[0]);
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return this.cl.getFields();
    }

    private static MemberBox extractGetMethod(MemberBox[] methods, boolean isStatic) {
        for (MemberBox method : methods) {
            if (!method.getArgTypes().isEmpty() || isStatic && !method.isStatic()) continue;
            TypeInfo type = method.getReturnType();
            if (type == TypeInfo.PRIMITIVE_VOID) break;
            return method;
        }
        return null;
    }

    private static MemberBox extractSetMethod(TypeInfo type, MemberBox[] methods, boolean isStatic) {
        MemberBox acceptableMatch = null;
        for (MemberBox method : methods) {
            List<TypeInfo> argTypes;
            if (isStatic && !method.isStatic() || (argTypes = method.getArgTypes()).size() != 1) continue;
            if (type.is(argTypes.get(0).asClass())) {
                return method;
            }
            if (acceptableMatch != null || !argTypes.get(0).asClass().isAssignableFrom(type.asClass())) continue;
            acceptableMatch = method;
        }
        return acceptableMatch;
    }

    private static MemberBox extractSetMethod(MemberBox[] methods, boolean isStatic) {
        for (MemberBox method : methods) {
            if (isStatic && !method.isStatic() || !method.getReturnType().isVoid() || method.getArgTypes().size() != 1) continue;
            return method;
        }
        return null;
    }

    Map<String, FieldAndMethods> getFieldAndMethodsObjects(Scriptable scope, Object javaObject, boolean isStatic) {
        Map<String, FieldAndMethods> ht;
        Map<String, FieldAndMethods> map = ht = isStatic ? this.staticFieldAndMethods : this.fieldAndMethods;
        if (ht == null) {
            return null;
        }
        int len = ht.size();
        HashMap<String, FieldAndMethods> result = new HashMap<String, FieldAndMethods>(len);
        for (FieldAndMethods fam : ht.values()) {
            FieldAndMethods famNew = new FieldAndMethods(scope, fam.methods, fam.field);
            famNew.javaObject = javaObject;
            result.put(fam.field.raw().getName(), famNew);
        }
        return result;
    }

    static JavaMembers lookupClass(Scriptable scope, Class<?> dynamicType, Class<?> staticType, boolean includeProtected) {
        JavaMembers members;
        ClassCache cache = ClassCache.get(scope);
        Map<ClassCache.CacheKey, JavaMembers> ct = cache.getClassCacheMap();
        Class<?> cl = dynamicType;
        Object secCtx = JavaMembers.getSecurityContext();
        while (true) {
            if ((members = ct.get(new ClassCache.CacheKey(cl, secCtx))) != null) {
                if (cl != dynamicType) {
                    ct.put(new ClassCache.CacheKey(dynamicType, secCtx), members);
                }
                return members;
            }
            try {
                members = JavaMembers.createJavaMembers(cache.getAssociatedScope(), cl, includeProtected);
            }
            catch (SecurityException e) {
                if (staticType != null && staticType.isInterface()) {
                    cl = staticType;
                    staticType = null;
                    continue;
                }
                Class<?> parent = cl.getSuperclass();
                if (parent == null) {
                    if (cl.isInterface()) {
                        parent = ScriptRuntime.ObjectClass;
                    } else {
                        throw e;
                    }
                }
                cl = parent;
                continue;
            }
            break;
        }
        if (cache.isCachingEnabled()) {
            ct.put(new ClassCache.CacheKey(cl, secCtx), members);
            if (cl != dynamicType) {
                ct.put(new ClassCache.CacheKey(dynamicType, secCtx), members);
            }
        }
        return members;
    }

    private static JavaMembers createJavaMembers(Scriptable associatedScope, Class<?> cl, boolean includeProtected) {
        if (STRICT_REFLECTIVE_ACCESS) {
            return new JavaMembers_jdk11(associatedScope, cl, includeProtected);
        }
        return new JavaMembers(associatedScope, cl, includeProtected);
    }

    private static Object getSecurityContext() {
        Object sec = null;
        SecurityManager sm = System.getSecurityManager();
        if (sm != null && (sec = sm.getSecurityContext()) instanceof AccessControlContext) {
            try {
                ((AccessControlContext)sec).checkPermission(allPermission);
                return null;
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return sec;
    }

    RuntimeException reportMemberNotFound(String memberName) {
        return Context.reportRuntimeErrorById("msg.java.member.not.found", this.cl.getName(), memberName);
    }

    static final class MethodSignature {
        private final String name;
        private final Class<?>[] args;

        private MethodSignature(String name, Class<?>[] args) {
            this.name = name;
            this.args = args;
        }

        MethodSignature(Method method) {
            this(method.getName(), method.getParameterTypes());
        }

        public boolean equals(Object o) {
            if (o instanceof MethodSignature) {
                MethodSignature ms = (MethodSignature)o;
                return ms.name.equals(this.name) && Arrays.equals(this.args, ms.args);
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode() ^ this.args.length;
        }
    }
}

