/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.common.profile.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.MessageLookup;
import org.opensaml.profile.action.AbstractConditionalProfileAction;
import org.opensaml.profile.action.AbstractProfileAction;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.profile.SAML1ActionSupport;
import org.opensaml.saml.saml2.profile.SAML2ActionSupport;
import org.slf4j.Logger;

public class AddNotOnOrAfterConditionToAssertions
extends AbstractConditionalProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddNotOnOrAfterConditionToAssertions.class);
    @Nonnull
    private Function<ProfileRequestContext, SAMLObject> responseLookupStrategy = new MessageLookup(SAMLObject.class).compose((Function)new OutboundMessageContextLookup());
    @Nullable
    private Function<ProfileRequestContext, Duration> assertionLifetimeStrategy;
    @Nonnull
    private Duration defaultAssertionLifetime = Duration.ofMinutes(5L);
    @NonnullBeforeExec
    private SAMLObject response;

    public void setResponseLookupStrategy(@Nonnull Function<ProfileRequestContext, SAMLObject> strategy) {
        this.checkSetterPreconditions();
        this.responseLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Response lookup strategy cannot be null");
    }

    public void setAssertionLifetimeStrategy(@Nullable Function<ProfileRequestContext, Duration> strategy) {
        this.checkSetterPreconditions();
        this.assertionLifetimeStrategy = strategy;
    }

    public void setDefaultAssertionLifetime(@Nonnull Duration lifetime) {
        this.checkSetterPreconditions();
        Constraint.isNotNull((Object)lifetime, (String)"Lifetime cannot be null");
        Constraint.isFalse((boolean)lifetime.isNegative(), (String)"Lifetime cannot be negative");
        this.defaultAssertionLifetime = lifetime;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.log.debug("{} Attempting to add NotOnOrAfter condition to every Assertion in outgoing Response", (Object)this.getLogPrefix());
        this.response = this.responseLookupStrategy.apply(profileRequestContext);
        if (this.response == null) {
            this.log.debug("{} No SAML Response located in current profile request context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        SAMLObject sAMLObject = this.response;
        if (sAMLObject instanceof Response) {
            Response saml1 = (Response)sAMLObject;
            if (saml1.getAssertions().isEmpty()) {
                this.log.debug("{} No assertions available, nothing to do", (Object)this.getLogPrefix());
                return false;
            }
        } else {
            sAMLObject = this.response;
            if (sAMLObject instanceof org.opensaml.saml.saml2.core.Response) {
                org.opensaml.saml.saml2.core.Response saml2 = (org.opensaml.saml.saml2.core.Response)sAMLObject;
                if (saml2.getAssertions().isEmpty()) {
                    this.log.debug("{} No assertions available, nothing to do", (Object)this.getLogPrefix());
                    return false;
                }
            } else {
                this.log.debug("{} Message returned by lookup strategy was not a SAML Response", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
                return false;
            }
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        block6: {
            Object object;
            Duration lifetime;
            block5: {
                Duration duration = lifetime = this.assertionLifetimeStrategy != null ? this.assertionLifetimeStrategy.apply(profileRequestContext) : null;
                if (lifetime == null) {
                    this.log.debug("{} No assertion lifetime supplied, using default", (Object)this.getLogPrefix());
                    lifetime = this.defaultAssertionLifetime;
                }
                if (!((object = this.response) instanceof Response)) break block5;
                Response saml1 = (Response)object;
                for (Assertion assertion : saml1.getAssertions()) {
                    Instant issueInstant = assertion.getIssueInstant();
                    if (issueInstant == null) {
                        issueInstant = Instant.now();
                    }
                    Instant expiration = issueInstant.plus(lifetime);
                    this.log.debug("{} Added NotOnOrAfter condition, indicating an expiration of {}, to Assertion {}", new Object[]{this.getLogPrefix(), expiration, assertion.getID()});
                    SAML1ActionSupport.addConditionsToAssertion((AbstractProfileAction)this, (Assertion)assertion).setNotOnOrAfter(expiration);
                }
                break block6;
            }
            object = this.response;
            if (!(object instanceof org.opensaml.saml.saml2.core.Response)) break block6;
            org.opensaml.saml.saml2.core.Response saml2 = (org.opensaml.saml.saml2.core.Response)object;
            for (org.opensaml.saml.saml2.core.Assertion assertion : saml2.getAssertions()) {
                Instant issueInstant = assertion.getIssueInstant();
                if (issueInstant == null) {
                    issueInstant = Instant.now();
                }
                Instant expiration = issueInstant.plus(lifetime);
                this.log.debug("{} Added NotOnOrAfter condition, indicating an expiration of {}, to Assertion {}", new Object[]{this.getLogPrefix(), expiration, assertion.getID()});
                SAML2ActionSupport.addConditionsToAssertion((AbstractProfileAction)this, (org.opensaml.saml.saml2.core.Assertion)assertion).setNotOnOrAfter(expiration);
            }
        }
    }
}

