/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.security.utils;

import org.apache.xml.security.exceptions.XMLSecurityException;
import org.apache.xml.security.utils.ElementProxy;
import org.apache.xml.security.utils.XMLUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class EncryptionElementProxy
extends ElementProxy {
    protected EncryptionElementProxy() {
    }

    public EncryptionElementProxy(Document doc) {
        if (doc == null) {
            throw new IllegalArgumentException("Document is null");
        }
        this.setDocument(doc);
        this.setElement(XMLUtils.createElementInEncryptionSpace(doc, this.getBaseLocalName()));
        String prefix = ElementProxy.getDefaultPrefix(this.getBaseNamespace());
        if (prefix != null && !prefix.isEmpty()) {
            this.getElement().setAttribute("xmlns:" + prefix, this.getBaseNamespace());
        }
    }

    public EncryptionElementProxy(Element element, String baseURI) throws XMLSecurityException {
        super(element, baseURI);
    }

    @Override
    public String getBaseNamespace() {
        return "http://www.w3.org/2001/04/xmlenc#";
    }
}

