/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.spring;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Collections;
import java.util.Map;
import javax.ws.rs.core.Application;
import org.apache.cxf.common.util.ClassHelper;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.jaxrs.utils.ResourceUtils;
import org.apache.cxf.message.Message;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public class SpringResourceFactory
implements ResourceProvider,
ApplicationContextAware {
    private Constructor<?> c;
    private Class<?> type;
    private ApplicationContext ac;
    private String beanId;
    private Method postConstructMethod;
    private Method preDestroyMethod;
    private boolean isSingleton;
    private boolean isPrototype;
    private boolean callPostConstruct;
    private boolean callPreDestroy = true;
    private String postConstructMethodName;
    private String preDestroyMethodName;
    private Object singletonInstance;

    public SpringResourceFactory() {
    }

    public SpringResourceFactory(String name) {
        this.beanId = name;
    }

    private void init() {
        this.type = ClassHelper.getRealClassFromClass((Class)this.ac.getType(this.beanId));
        if (Proxy.isProxyClass(this.type)) {
            this.type = ClassHelper.getRealClass((Object)this.ac.getBean(this.beanId));
        }
        this.isSingleton = this.ac.isSingleton(this.beanId);
        this.postConstructMethod = ResourceUtils.findPostConstructMethod(this.type, this.postConstructMethodName);
        this.preDestroyMethod = ResourceUtils.findPreDestroyMethod(this.type, this.preDestroyMethodName);
        if (this.isSingleton()) {
            try {
                this.singletonInstance = this.ac.getBean(this.beanId);
            }
            catch (BeansException beansException) {
                // empty catch block
            }
            if (this.singletonInstance != null) {
                return;
            }
        } else {
            this.isPrototype = this.ac.isPrototype(this.beanId);
        }
        this.c = ResourceUtils.findResourceConstructor(this.type, !this.isSingleton());
        if (this.c == null) {
            throw new RuntimeException("Resource class " + String.valueOf(this.type) + " has no valid constructor");
        }
    }

    @Override
    public Object getInstance(Message m) {
        if (this.singletonInstance != null) {
            return this.singletonInstance;
        }
        ProviderInfo application = m == null ? null : (ProviderInfo)m.getExchange().getEndpoint().get((Object)Application.class.getName());
        Map mapValues = CastUtils.cast(application == null ? null : Collections.singletonMap(Application.class, application.getProvider()));
        Object[] values = ResourceUtils.createConstructorArguments(this.c, m, !this.isSingleton(), mapValues);
        Object instance = values.length > 0 ? this.ac.getBean(this.beanId, values) : this.ac.getBean(this.beanId);
        this.initInstance(m, instance);
        return instance;
    }

    protected void initInstance(Message m, Object instance) {
        if (this.isCallPostConstruct()) {
            InjectionUtils.invokeLifeCycleMethod(ClassHelper.getRealObject((Object)instance), this.postConstructMethod);
        }
    }

    @Override
    public boolean isSingleton() {
        return this.isSingleton;
    }

    @Override
    public void releaseInstance(Message m, Object o) {
        if (this.doCallPreDestroy()) {
            InjectionUtils.invokeLifeCycleMethod(o, this.preDestroyMethod);
        }
    }

    protected boolean doCallPreDestroy() {
        return this.isCallPreDestroy() && this.isPrototype;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.ac = applicationContext;
        this.init();
    }

    public void setBeanId(String serviceBeanId) {
        this.beanId = serviceBeanId;
    }

    public ApplicationContext getApplicationContext() {
        return this.ac;
    }

    Constructor<?> getBeanConstructor() {
        return this.c;
    }

    @Override
    public Class<?> getResourceClass() {
        return this.type;
    }

    public void setCallPostConstruct(boolean callPostConstruct) {
        this.callPostConstruct = callPostConstruct;
    }

    public boolean isCallPostConstruct() {
        return this.callPostConstruct;
    }

    public void setCallPreDestroy(boolean callPreDestroy) {
        this.callPreDestroy = callPreDestroy;
    }

    public boolean isCallPreDestroy() {
        return this.callPreDestroy;
    }

    public void setPreDestroyMethodName(String preDestroyMethodName) {
        this.preDestroyMethodName = preDestroyMethodName;
    }

    public void setPostConstructMethodName(String postConstructMethodName) {
        this.postConstructMethodName = postConstructMethodName;
    }
}

