/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.statistics.inference;

import java.util.Arrays;
import java.util.Objects;
import java.util.function.DoubleSupplier;
import java.util.function.DoubleUnaryOperator;
import java.util.function.IntToDoubleFunction;
import org.apache.commons.numbers.combinatorics.BinomialCoefficientDouble;
import org.apache.commons.numbers.combinatorics.Factorial;
import org.apache.commons.numbers.core.ArithmeticUtils;
import org.apache.commons.numbers.core.Sum;
import org.apache.commons.rng.UniformRandomProvider;
import org.apache.commons.statistics.inference.AlternativeHypothesis;
import org.apache.commons.statistics.inference.Arguments;
import org.apache.commons.statistics.inference.BaseSignificanceResult;
import org.apache.commons.statistics.inference.Inequality;
import org.apache.commons.statistics.inference.InferenceException;
import org.apache.commons.statistics.inference.KolmogorovSmirnovDistribution;
import org.apache.commons.statistics.inference.PValueMethod;

public final class KolmogorovSmirnovTest {
    private static final String SAMPLE_1_NAME = "Sample 1";
    private static final String SAMPLE_2_NAME = "Sample 2";
    private static final int LARGE_SAMPLE = 10000;
    private static final int MAX_FACTORIAL = 170;
    private static final int MAX_ARRAY_SIZE = 0x7FFFFFF7;
    private static final long MAX_LCM_TWO_SAMPLE_EXACT_P = 0x80000000L;
    private static final int[] IGNORED_SIGN = new int[1];
    private static final long[] IGNORED_D = new long[2];
    private static final KolmogorovSmirnovTest DEFAULT = new KolmogorovSmirnovTest(AlternativeHypothesis.TWO_SIDED, PValueMethod.AUTO, false, null, 1000);
    private final AlternativeHypothesis alternative;
    private final PValueMethod pValueMethod;
    private final boolean strictInequality;
    private final UniformRandomProvider rng;
    private final int iterations;

    private KolmogorovSmirnovTest(AlternativeHypothesis alternative, PValueMethod method, boolean strict, UniformRandomProvider rng, int iterations) {
        this.alternative = alternative;
        this.pValueMethod = method;
        this.strictInequality = strict;
        this.rng = rng;
        this.iterations = iterations;
    }

    public static KolmogorovSmirnovTest withDefaults() {
        return DEFAULT;
    }

    public KolmogorovSmirnovTest with(AlternativeHypothesis v) {
        return new KolmogorovSmirnovTest(Objects.requireNonNull(v), this.pValueMethod, this.strictInequality, this.rng, this.iterations);
    }

    public KolmogorovSmirnovTest with(PValueMethod v) {
        return new KolmogorovSmirnovTest(this.alternative, Objects.requireNonNull(v), this.strictInequality, this.rng, this.iterations);
    }

    public KolmogorovSmirnovTest with(Inequality v) {
        return new KolmogorovSmirnovTest(this.alternative, this.pValueMethod, Objects.requireNonNull(v) == Inequality.STRICT, this.rng, this.iterations);
    }

    public KolmogorovSmirnovTest with(UniformRandomProvider v) {
        return new KolmogorovSmirnovTest(this.alternative, this.pValueMethod, this.strictInequality, Objects.requireNonNull(v), this.iterations);
    }

    public KolmogorovSmirnovTest withIterations(int v) {
        return new KolmogorovSmirnovTest(this.alternative, this.pValueMethod, this.strictInequality, this.rng, Arguments.checkStrictlyPositive(v));
    }

    public double statistic(double[] x, DoubleUnaryOperator cdf) {
        return this.computeStatistic(x, cdf, IGNORED_SIGN);
    }

    public double statistic(double[] x, double[] y) {
        int n = KolmogorovSmirnovTest.checkArrayLength(x);
        int m = KolmogorovSmirnovTest.checkArrayLength(y);
        long dnm = this.computeIntegralKolmogorovSmirnovStatistic((double[])x.clone(), (double[])y.clone(), IGNORED_SIGN, IGNORED_D);
        return KolmogorovSmirnovTest.computeD(dnm, n, m, ArithmeticUtils.gcd((int)n, (int)m));
    }

    public OneResult test(double[] x, DoubleUnaryOperator cdf) {
        double p;
        int[] sign = new int[]{0};
        double d = this.computeStatistic(x, cdf, sign);
        if (this.alternative == AlternativeHypothesis.TWO_SIDED) {
            PValueMethod method = this.pValueMethod;
            if (method == PValueMethod.AUTO) {
                method = PValueMethod.EXACT;
            }
            p = method == PValueMethod.ASYMPTOTIC ? KolmogorovSmirnovDistribution.ksSum(Math.sqrt(x.length) * d) : KolmogorovSmirnovDistribution.Two.sf(d, x.length);
        } else {
            p = KolmogorovSmirnovDistribution.One.sf(d, x.length);
        }
        return new OneResult(d, sign[0], p);
    }

    public TwoResult test(double[] x, double[] y) {
        double p2;
        double p;
        double d2;
        int n = KolmogorovSmirnovTest.checkArrayLength(x);
        int m = KolmogorovSmirnovTest.checkArrayLength(y);
        PValueMethod method = this.pValueMethod;
        int[] sign = new int[]{0};
        long[] tiesD = new long[]{0L, 0L};
        double[] sx = (double[])x.clone();
        double[] sy = (double[])y.clone();
        long dnm = this.computeIntegralKolmogorovSmirnovStatistic(sx, sy, sign, tiesD);
        if (method == PValueMethod.AUTO) {
            method = Math.max(n, m) < 10000 ? PValueMethod.EXACT : PValueMethod.ASYMPTOTIC;
        }
        int gcd = ArithmeticUtils.gcd((int)n, (int)m);
        double d = KolmogorovSmirnovTest.computeD(dnm, n, m, gcd);
        boolean significantTies = tiesD[1] > dnm;
        double d3 = d2 = significantTies ? KolmogorovSmirnovTest.computeD(tiesD[1], n, m, gcd) : d;
        if (method == PValueMethod.ESTIMATE) {
            p = this.estimateP(sx, sy, dnm);
            p2 = Double.NaN;
        } else {
            boolean exact = method == PValueMethod.EXACT;
            p = p2 = this.twoSampleP(dnm, n, m, gcd, d, exact);
            if (significantTies) {
                p2 = this.twoSampleP(tiesD[1], n, m, gcd, d2, exact);
            }
        }
        return new TwoResult(d, sign[0], p, significantTies, d2, p2);
    }

    private double estimateP(double[] x, double[] y, long dnm) {
        long minus;
        long plus;
        long d;
        if (this.rng == null) {
            throw new IllegalStateException("No source of randomness");
        }
        long l = d = this.strictInequality ? dnm : dnm - 1L;
        if (this.alternative == AlternativeHypothesis.GREATER_THAN) {
            plus = d;
            minus = Long.MIN_VALUE;
        } else if (this.alternative == AlternativeHypothesis.LESS_THAN) {
            plus = Long.MAX_VALUE;
            minus = -d;
        } else {
            plus = d;
            minus = -d;
        }
        if (0L < minus || 0L > plus) {
            return 1.0;
        }
        DoubleSupplier gen = KolmogorovSmirnovTest.createSampler(x, y, this.rng);
        int count = 0;
        for (int i = this.iterations; i > 0; --i) {
            int j;
            for (j = 0; j < x.length; ++j) {
                x[j] = gen.getAsDouble();
            }
            for (j = 0; j < y.length; ++j) {
                y[j] = gen.getAsDouble();
            }
            if (!KolmogorovSmirnovTest.testIntegralKolmogorovSmirnovStatistic(x, y, plus, minus)) continue;
            ++count;
        }
        return (double)count / (double)this.iterations;
    }

    private double computeStatistic(double[] x, DoubleUnaryOperator cdf, int[] sign) {
        int n = KolmogorovSmirnovTest.checkArrayLength(x);
        double nd = n;
        double[] sx = KolmogorovSmirnovTest.sort((double[])x.clone(), "Sample");
        double d = 0.0;
        if (this.alternative == AlternativeHypothesis.GREATER_THAN) {
            for (int i = 0; i < n; ++i) {
                double yi = cdf.applyAsDouble(sx[i]);
                double dp = (double)(i + 1) / nd - yi;
                d = dp > d ? dp : d;
            }
            sign[0] = 1;
        } else if (this.alternative == AlternativeHypothesis.LESS_THAN) {
            for (int i = 0; i < n; ++i) {
                double yi = cdf.applyAsDouble(sx[i]);
                double dn = yi - (double)i / nd;
                d = dn > d ? dn : d;
            }
            sign[0] = -1;
        } else {
            double plus = 0.0;
            double minus = 0.0;
            for (int i = 0; i < n; ++i) {
                double yi = cdf.applyAsDouble(sx[i]);
                double dn = yi - (double)i / nd;
                double dp = (double)(i + 1) / nd - yi;
                minus = dn > minus ? dn : minus;
                plus = dp > plus ? dp : plus;
            }
            sign[0] = Double.compare(plus, minus);
            d = Math.max(plus, minus);
        }
        return d;
    }

    private long computeIntegralKolmogorovSmirnovStatistic(double[] x, double[] y, int[] sign, long[] tiesD) {
        KolmogorovSmirnovTest.sort(x, SAMPLE_1_NAME);
        KolmogorovSmirnovTest.sort(y, SAMPLE_2_NAME);
        int n = x.length;
        int m = y.length;
        int i = 0;
        int j = 0;
        long d = 0L;
        long plus = 0L;
        long minus = 0L;
        long tplus = 0L;
        long tminus = 0L;
        do {
            double z;
            if (x[i] < y[j]) {
                z = x[i];
                do {
                    d += (long)m;
                } while (++i < n && x[i] == z);
                plus = d > plus ? d : plus;
                continue;
            }
            if (x[i] > y[j]) {
                z = y[j];
                do {
                    d -= (long)n;
                } while (++j < m && y[j] == z);
                minus = d < minus ? d : minus;
                continue;
            }
            z = x[i];
            long dd = d;
            int k = i;
            while (++i < n && x[i] == z) {
            }
            tplus = (d += (long)(k = i - k) * (long)m) > tplus ? d : tplus;
            k = j;
            while (++j < m && y[j] == z) {
            }
            k = j - k;
            tminus = Math.min(tminus, dd - (long)k * (long)n);
            if ((d -= (long)k * (long)n) > plus) {
                plus = d;
                continue;
            }
            if (d >= minus) continue;
            minus = d;
        } while (i < n && j < m);
        tiesD[0] = tplus | tminus;
        if (this.alternative == AlternativeHypothesis.GREATER_THAN) {
            sign[0] = 1;
            tiesD[1] = tplus;
            return plus;
        }
        if (this.alternative == AlternativeHypothesis.LESS_THAN) {
            sign[0] = -1;
            tiesD[1] = -tminus;
            return -minus;
        }
        sign[0] = Double.compare(plus, -minus);
        d = Math.max(plus, -minus);
        tiesD[1] = Math.max(tplus, -tminus);
        return d;
    }

    private static boolean testIntegralKolmogorovSmirnovStatistic(double[] x, double[] y, long plus, long minus) {
        Arrays.sort(x);
        Arrays.sort(y);
        int n = x.length;
        int m = y.length;
        int i = 0;
        int j = 0;
        long d = 0L;
        do {
            double z;
            if (x[i] < y[j]) {
                z = x[i];
                do {
                    d += (long)m;
                } while (++i < n && x[i] == z);
                if (d <= plus) continue;
                return true;
            }
            if (x[i] > y[j]) {
                z = y[j];
                do {
                    d -= (long)n;
                } while (++j < m && y[j] == z);
                if (d >= minus) continue;
                return true;
            }
            z = x[i];
            do {
                d += (long)m;
            } while (++i < n && x[i] == z);
            do {
                d -= (long)n;
            } while (++j < m && y[j] == z);
            if (d <= plus && d >= minus) continue;
            return true;
        } while (i < n && j < m);
        return false;
    }

    private static DoubleSupplier createSampler(double[] x, double[] y, UniformRandomProvider rng) {
        return KolmogorovSmirnovTest.createSampler(x, y, rng, 0x7FFFFFF7);
    }

    static DoubleSupplier createSampler(double[] x, double[] y, UniformRandomProvider rng, int maxArraySize) {
        int n = x.length;
        int m = y.length;
        int len = n + m;
        if (len - maxArraySize > 0) {
            double[] xx = (double[])x.clone();
            double[] yy = (double[])y.clone();
            IntToDoubleFunction nextX = i -> xx[n + i];
            IntToDoubleFunction nextY = i -> yy[i];
            IntToDoubleFunction[] next = new IntToDoubleFunction[]{nextY, nextX};
            return () -> {
                int i = rng.nextInt(-n, m);
                return next[i >>> 31].applyAsDouble(i);
            };
        }
        double[] z = new double[len];
        System.arraycopy(x, 0, z, 0, n);
        System.arraycopy(y, 0, z, n, m);
        return () -> z[rng.nextInt(len)];
    }

    private static double computeD(long dnm, int n, int m, int gcd) {
        long a = dnm / (long)gcd;
        int b = m / gcd;
        return (double)a / ((double)n * (double)b);
    }

    private double twoSampleP(long dnm, int n, int m, int gcd, double d, boolean exact) {
        double p = -1.0;
        if (exact) {
            p = KolmogorovSmirnovTest.twoSampleExactP(dnm, n, m, gcd, this.strictInequality, this.alternative == AlternativeHypothesis.TWO_SIDED);
        }
        if (p < 0.0) {
            p = KolmogorovSmirnovTest.twoSampleApproximateP(d, n, m, this.alternative == AlternativeHypothesis.TWO_SIDED);
        }
        return p;
    }

    static double twoSampleExactP(long dnm, int n, int m, int gcd, boolean strict, boolean twoSided) {
        long lcm;
        long d = dnm / (long)gcd + (long)(strict ? 1 : 0);
        if (d > (lcm = (long)n * (long)(m / gcd))) {
            return 0.0;
        }
        int a = Math.min(n, m);
        int b = Math.max(n, m);
        if (twoSided) {
            if (d * (long)gcd <= (long)a) {
                return 1.0;
            }
            if (n == m) {
                return KolmogorovSmirnovTest.twoSampleTwoSidedPOutsideSquare(d, n);
            }
            return KolmogorovSmirnovTest.twoSampleTwoSidedPStabilizedInner(d, b, a, gcd);
        }
        if (d <= 0L) {
            return 1.0;
        }
        if (n == m) {
            return KolmogorovSmirnovTest.twoSampleOneSidedPOutsideSquare(d, n);
        }
        return KolmogorovSmirnovTest.twoSampleOneSidedPOutside(d, a, b, gcd);
    }

    private static double twoSampleTwoSidedPStabilizedInner(long d, int n, int m, int gcd) {
        if ((long)n * (long)(m / gcd) > 0x80000000L) {
            return -1.0;
        }
        long dnm = d * (long)gcd;
        int endJ = Math.min(m + 1, (int)((dnm + (long)n - 1L) / (long)n));
        double[] cij = new double[Math.min(m + 1, 2 * endJ + 2)];
        for (int j = endJ; j < cij.length; ++j) {
            cij[j] = 1.0;
        }
        int startJ = 0;
        int length = endJ;
        double val = -1.0;
        long im = 0L;
        for (int i = 1; i <= n; ++i) {
            int lastStartJ = startJ;
            if ((startJ = (im += (long)m) < dnm ? 0 : Math.min(m, (int)((im - dnm) / (long)n) + 1)) >= (endJ = Math.min(m + 1, (int)((dnm + im + (long)n - 1L) / (long)n)))) {
                return 1.0;
            }
            val = startJ == 0 ? 0.0 : 1.0;
            for (int j = startJ; j < endJ; ++j) {
                cij[j - startJ] = val = (cij[j - lastStartJ] * (double)i + val * (double)j) / ((double)i + (double)j);
            }
            int lastLength = length;
            length = endJ - startJ;
            for (int j = lastLength - length - 1; j >= 0; --j) {
                cij[length + j] = 1.0;
            }
        }
        return val;
    }

    private static double twoSampleOneSidedPOutside(long d, int n, int m, int gcd) {
        long lm = m;
        if ((long)n + lm > Integer.MAX_VALUE) {
            return -1.0;
        }
        double binom = KolmogorovSmirnovTest.binom(m + n, n);
        if (binom == Double.POSITIVE_INFINITY) {
            return -1.0;
        }
        long dnm = d * (long)gcd;
        int x0 = (int)((dnm + (long)n - 1L) / (long)n);
        if (x0 >= m) {
            return 1.0 / binom;
        }
        int maxy = (int)(((long)n * lm - dnm + (long)m) / (long)m);
        int[] xy = new int[maxy];
        double[] bxy = new double[maxy];
        xy[0] = x0;
        bxy[0] = 1.0;
        for (int y = 1; y < maxy; ++y) {
            int x = (int)((dnm + lm * (long)y + (long)n - 1L) / (long)n);
            Sum b = Sum.create();
            for (int yy = 0; yy < y; ++yy) {
                b.addProduct(bxy[yy], -KolmogorovSmirnovTest.binom(x - xy[yy] + y - yy, y - yy));
            }
            b.add(KolmogorovSmirnovTest.binom(x + y, y));
            xy[y] = x;
            bxy[y] = b.getAsDouble();
        }
        Sum sum = Sum.create();
        for (int y = 0; y < maxy; ++y) {
            sum.addProduct(bxy[y], KolmogorovSmirnovTest.binom(m + n - xy[y] - y, n - y));
        }
        return KolmogorovSmirnovDistribution.clipProbability(sum.getAsDouble() / binom);
    }

    private static double twoSampleOneSidedPOutsideSquare(long d, int n) {
        int a = (int)d;
        if (n + a <= 170) {
            double x = Factorial.doubleValue((int)n);
            double y = Factorial.doubleValue((int)(n - a));
            double z = Factorial.doubleValue((int)(n + a));
            return x / y * (x / z);
        }
        double p = 1.0;
        for (int i = 0; i < a && p != 0.0; p *= (double)(n - i) / (1.0 + (double)n + (double)i), ++i) {
        }
        return p;
    }

    private static double twoSampleTwoSidedPOutsideSquare(long d, int n) {
        double p0a = KolmogorovSmirnovTest.twoSampleOneSidedPOutsideSquare(d, n);
        if (p0a == 0.0) {
            return 0.0;
        }
        int a = (int)d;
        double p = 0.0;
        for (int j = n / a; j > 0; --j) {
            double pja = 1.0;
            int jaa = j * a + a;
            for (int i = j * a; i < jaa; ++i) {
                pja *= (double)(n - i) / (1.0 + (double)n + (double)i);
            }
            p = pja * (1.0 - p);
        }
        p = p0a * (1.0 - p);
        return Math.min(1.0, 2.0 * p);
    }

    private static double binom(int n, int k) {
        return BinomialCoefficientDouble.value((int)n, (int)k);
    }

    static double twoSampleApproximateP(double d, int n, int m, boolean twoSided) {
        double nn = Math.min(n, m);
        double mm = Math.max(n, m);
        if (twoSided) {
            return KolmogorovSmirnovDistribution.Two.sf(d, (int)Math.round(mm * nn / (mm + nn)));
        }
        double z = d * Math.sqrt(nn * mm / (nn + mm));
        return Math.exp(-2.0 * z * z - 2.0 * z * (mm + 2.0 * nn) / Math.sqrt(mm * nn * (mm + nn)) / 3.0);
    }

    private static int checkArrayLength(double[] array) {
        int n = array.length;
        if (n <= 1) {
            throw new InferenceException("Values size %s < 2", n);
        }
        return n;
    }

    private static double[] sort(double[] x, String name) {
        Arrays.sort(x);
        if (Double.isNaN(x[x.length - 1])) {
            throw new InferenceException(name + " contains NaN");
        }
        return x;
    }

    public static final class TwoResult
    extends OneResult {
        private final boolean significantTies;
        private final double upperD;
        private final double upperP;

        TwoResult(double statistic, int sign, double p, boolean significantTies, double upperD, double upperP) {
            super(statistic, sign, p);
            this.significantTies = significantTies;
            this.upperD = upperD;
            this.upperP = upperP;
        }

        @Override
        public double getStatistic() {
            return super.getStatistic();
        }

        public boolean hasSignificantTies() {
            return this.significantTies;
        }

        public double getUpperD() {
            return this.upperD;
        }

        public double getUpperPValue() {
            return this.upperP;
        }
    }

    public static class OneResult
    extends BaseSignificanceResult {
        private final int sign;

        OneResult(double statistic, int sign, double p) {
            super(statistic, p);
            this.sign = sign;
        }

        public int getSign() {
            return this.sign;
        }
    }
}

