/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.lang3;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.lang.reflect.Modifier;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Paths;
import org.apache.commons.lang3.AbstractLangTest;
import org.apache.commons.lang3.LangAssertions;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.text.translate.CharSequenceTranslator;
import org.apache.commons.lang3.text.translate.NumericEntityEscaper;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@Deprecated
class StringEscapeUtilsTest
extends AbstractLangTest {
    private static final String FOO = "foo";
    private static final String[][] HTML_ESCAPES = new String[][]{{"no escaping", "plain text", "plain text"}, {"no escaping", "plain text", "plain text"}, {"empty string", "", ""}, {"null", null, null}, {"ampersand", "bread &amp; butter", "bread & butter"}, {"quotes", "&quot;bread&quot; &amp; butter", "\"bread\" & butter"}, {"final character only", "greater than &gt;", "greater than >"}, {"first character only", "&lt; less than", "< less than"}, {"apostrophe", "Huntington's chorea", "Huntington's chorea"}, {"languages", "English,Fran&ccedil;ais,\u65e5\u672c\u8a9e (nihongo)", "English,Fran\u00e7ais,\u65e5\u672c\u8a9e (nihongo)"}, {"8-bit ascii shouldn't number-escape", "\u0080\u009f", "\u0080\u009f"}};

    StringEscapeUtilsTest() {
    }

    private void assertEscapeJava(String escaped, String original) throws IOException {
        this.assertEscapeJava(null, escaped, original);
    }

    private void assertEscapeJava(String message, String expected, String original) throws IOException {
        String converted = StringEscapeUtils.escapeJava((String)original);
        message = "escapeJava(String) failed" + (message == null ? "" : ": " + message);
        Assertions.assertEquals((Object)expected, (Object)converted, (String)message);
        StringWriter writer = new StringWriter();
        StringEscapeUtils.ESCAPE_JAVA.translate((CharSequence)original, (Writer)writer);
        Assertions.assertEquals((Object)expected, (Object)writer.toString());
    }

    private void assertUnescapeJava(String unescaped, String original) throws IOException {
        this.assertUnescapeJava(null, unescaped, original);
    }

    private void assertUnescapeJava(String message, String unescaped, String original) throws IOException {
        String expected = unescaped;
        String actual = StringEscapeUtils.unescapeJava((String)original);
        Assertions.assertEquals((Object)expected, (Object)actual, (String)("unescape(String) failed" + (message == null ? "" : ": " + message) + ": expected '" + StringEscapeUtils.escapeJava((String)expected) + "' actual '" + StringEscapeUtils.escapeJava((String)actual) + "'"));
        StringWriter writer = new StringWriter();
        StringEscapeUtils.UNESCAPE_JAVA.translate((CharSequence)original, (Writer)writer);
        Assertions.assertEquals((Object)unescaped, (Object)writer.toString());
    }

    private void checkCsvEscapeWriter(String expected, String value) throws IOException {
        StringWriter writer = new StringWriter();
        StringEscapeUtils.ESCAPE_CSV.translate((CharSequence)value, (Writer)writer);
        Assertions.assertEquals((Object)expected, (Object)writer.toString());
    }

    private void checkCsvUnescapeWriter(String expected, String value) throws IOException {
        StringWriter writer = new StringWriter();
        StringEscapeUtils.UNESCAPE_CSV.translate((CharSequence)value, (Writer)writer);
        Assertions.assertEquals((Object)expected, (Object)writer.toString());
    }

    @Test
    void testConstructor() {
        Assertions.assertNotNull((Object)new StringEscapeUtils());
        Constructor<?>[] cons = StringEscapeUtils.class.getDeclaredConstructors();
        Assertions.assertEquals((int)1, (int)cons.length);
        Assertions.assertTrue((boolean)Modifier.isPublic(cons[0].getModifiers()));
        Assertions.assertTrue((boolean)Modifier.isPublic(StringEscapeUtils.class.getModifiers()));
        Assertions.assertFalse((boolean)Modifier.isFinal(StringEscapeUtils.class.getModifiers()));
    }

    @Test
    void testEscapeCsvIllegalStateException() {
        StringWriter writer = new StringWriter();
        Assertions.assertThrows(IllegalStateException.class, () -> StringEscapeUtils.ESCAPE_CSV.translate((CharSequence)FOO, -1, (Writer)writer));
    }

    @Test
    void testEscapeCsvString() {
        Assertions.assertEquals((Object)"foo.bar", (Object)StringEscapeUtils.escapeCsv((String)"foo.bar"));
        Assertions.assertEquals((Object)"\"foo,bar\"", (Object)StringEscapeUtils.escapeCsv((String)"foo,bar"));
        Assertions.assertEquals((Object)"\"foo\nbar\"", (Object)StringEscapeUtils.escapeCsv((String)"foo\nbar"));
        Assertions.assertEquals((Object)"\"foo\rbar\"", (Object)StringEscapeUtils.escapeCsv((String)"foo\rbar"));
        Assertions.assertEquals((Object)"\"foo\"\"bar\"", (Object)StringEscapeUtils.escapeCsv((String)"foo\"bar"));
        Assertions.assertEquals((Object)"foo\ud84c\udfb4bar", (Object)StringEscapeUtils.escapeCsv((String)"foo\ud84c\udfb4bar"));
        Assertions.assertEquals((Object)"", (Object)StringEscapeUtils.escapeCsv((String)""));
        Assertions.assertNull((Object)StringEscapeUtils.escapeCsv(null));
    }

    @Test
    void testEscapeCsvWriter() throws Exception {
        this.checkCsvEscapeWriter("foo.bar", "foo.bar");
        this.checkCsvEscapeWriter("\"foo,bar\"", "foo,bar");
        this.checkCsvEscapeWriter("\"foo\nbar\"", "foo\nbar");
        this.checkCsvEscapeWriter("\"foo\rbar\"", "foo\rbar");
        this.checkCsvEscapeWriter("\"foo\"\"bar\"", "foo\"bar");
        this.checkCsvEscapeWriter("foo\ud84c\udfb4bar", "foo\ud84c\udfb4bar");
        this.checkCsvEscapeWriter("", null);
        this.checkCsvEscapeWriter("", "");
    }

    @Test
    void testEscapeEcmaScript() {
        Assertions.assertNull((Object)StringEscapeUtils.escapeEcmaScript(null));
        LangAssertions.assertNullPointerException(() -> StringEscapeUtils.ESCAPE_ECMASCRIPT.translate(null, null));
        LangAssertions.assertNullPointerException(() -> StringEscapeUtils.ESCAPE_ECMASCRIPT.translate((CharSequence)"", null));
        Assertions.assertEquals((Object)"He didn\\'t say, \\\"stop!\\\"", (Object)StringEscapeUtils.escapeEcmaScript((String)"He didn't say, \"stop!\""));
        Assertions.assertEquals((Object)"document.getElementById(\\\"test\\\").value = \\'<script>alert(\\'aaa\\');<\\/script>\\';", (Object)StringEscapeUtils.escapeEcmaScript((String)"document.getElementById(\"test\").value = '<script>alert('aaa');</script>';"));
    }

    @Test
    void testEscapeHiragana() {
        String original = "\u304b\u304c\u3068";
        String escaped = StringEscapeUtils.escapeHtml4((String)"\u304b\u304c\u3068");
        Assertions.assertEquals((Object)"\u304b\u304c\u3068", (Object)escaped, (String)"Hiragana character Unicode behavior should not be being escaped by escapeHtml4");
        String unescaped = StringEscapeUtils.unescapeHtml4((String)escaped);
        Assertions.assertEquals((Object)escaped, (Object)unescaped, (String)"Hiragana character Unicode behavior has changed - expected no unescaping");
    }

    @Test
    void testEscapeHtml() throws IOException {
        for (String[] element : HTML_ESCAPES) {
            String message = element[0];
            String expected = element[1];
            String original = element[2];
            Assertions.assertEquals((Object)expected, (Object)StringEscapeUtils.escapeHtml4((String)original), (String)message);
            StringWriter sw = new StringWriter();
            StringEscapeUtils.ESCAPE_HTML4.translate((CharSequence)original, (Writer)sw);
            String actual = original == null ? null : sw.toString();
            Assertions.assertEquals((Object)expected, (Object)actual, (String)message);
        }
    }

    @Test
    void testEscapeHtmlHighUnicode() {
        byte[] data = new byte[]{-16, -99, -115, -94};
        String original = new String(data, StandardCharsets.UTF_8);
        String escaped = StringEscapeUtils.escapeHtml4((String)original);
        Assertions.assertEquals((Object)original, (Object)escaped, (String)"High Unicode should not have been escaped");
        String unescaped = StringEscapeUtils.unescapeHtml4((String)escaped);
        Assertions.assertEquals((Object)original, (Object)unescaped, (String)"High Unicode should have been unchanged");
    }

    @Test
    void testEscapeHtmlVersions() {
        Assertions.assertEquals((Object)"&Beta;", (Object)StringEscapeUtils.escapeHtml4((String)"\u0392"));
        Assertions.assertEquals((Object)"\u0392", (Object)StringEscapeUtils.unescapeHtml4((String)"&Beta;"));
    }

    @Test
    void testEscapeJava() throws IOException {
        Assertions.assertNull((Object)StringEscapeUtils.escapeJava(null));
        LangAssertions.assertNullPointerException(() -> StringEscapeUtils.ESCAPE_JAVA.translate(null, null));
        LangAssertions.assertNullPointerException(() -> StringEscapeUtils.ESCAPE_JAVA.translate((CharSequence)"", null));
        this.assertEscapeJava("empty string", "", "");
        this.assertEscapeJava(FOO, FOO);
        this.assertEscapeJava("tab", "\\t", "\t");
        this.assertEscapeJava("backslash", "\\\\", "\\");
        this.assertEscapeJava("single quote should not be escaped", "'", "'");
        this.assertEscapeJava("\\\\\\b\\t\\r", "\\\b\t\r");
        this.assertEscapeJava("\\u1234", "\u1234");
        this.assertEscapeJava("\\u0234", "\u0234");
        this.assertEscapeJava("\\u00EF", "\u00ef");
        this.assertEscapeJava("\\u0001", "\u0001");
        this.assertEscapeJava("Should use capitalized Unicode hex", "\\uABCD", "\uabcd");
        this.assertEscapeJava("He didn't say, \\\"stop!\\\"", "He didn't say, \"stop!\"");
        this.assertEscapeJava("non-breaking space", "This space is non-breaking:\\u00A0", "This space is non-breaking:\u00a0");
        this.assertEscapeJava("\\uABCD\\u1234\\u012C", "\uabcd\u1234\u012c");
    }

    @Test
    void testEscapeJavaWithSlash() {
        String input = "String with a slash (/) in it";
        String expected = "String with a slash (/) in it";
        String actual = StringEscapeUtils.escapeJava((String)"String with a slash (/) in it");
        Assertions.assertEquals((Object)"String with a slash (/) in it", (Object)actual);
    }

    @Test
    void testEscapeJson() {
        Assertions.assertNull((Object)StringEscapeUtils.escapeJson(null));
        LangAssertions.assertNullPointerException(() -> StringEscapeUtils.ESCAPE_JSON.translate(null, null));
        LangAssertions.assertNullPointerException(() -> StringEscapeUtils.ESCAPE_JSON.translate((CharSequence)"", null));
        Assertions.assertEquals((Object)"He didn't say, \\\"stop!\\\"", (Object)StringEscapeUtils.escapeJson((String)"He didn't say, \"stop!\""));
        String expected = "\\\"foo\\\" isn't \\\"bar\\\". specials: \\b\\r\\n\\f\\t\\\\\\/";
        String input = "\"foo\" isn't \"bar\". specials: \b\r\n\f\t\\/";
        Assertions.assertEquals((Object)"\\\"foo\\\" isn't \\\"bar\\\". specials: \\b\\r\\n\\f\\t\\\\\\/", (Object)StringEscapeUtils.escapeJson((String)"\"foo\" isn't \"bar\". specials: \b\r\n\f\t\\/"));
    }

    @Test
    void testEscapeXml() throws Exception {
        Assertions.assertEquals((Object)"&lt;abc&gt;", (Object)StringEscapeUtils.escapeXml((String)"<abc>"));
        Assertions.assertEquals((Object)"<abc>", (Object)StringEscapeUtils.unescapeXml((String)"&lt;abc&gt;"));
        Assertions.assertEquals((Object)"\u00a1", (Object)StringEscapeUtils.escapeXml((String)"\u00a1"), (String)"XML should not escape >0x7f values");
        Assertions.assertEquals((Object)"\u00a0", (Object)StringEscapeUtils.unescapeXml((String)"&#160;"), (String)"XML should be able to unescape >0x7f values");
        Assertions.assertEquals((Object)"\u00a0", (Object)StringEscapeUtils.unescapeXml((String)"&#0160;"), (String)"XML should be able to unescape >0x7f values with one leading 0");
        Assertions.assertEquals((Object)"\u00a0", (Object)StringEscapeUtils.unescapeXml((String)"&#00160;"), (String)"XML should be able to unescape >0x7f values with two leading 0s");
        Assertions.assertEquals((Object)"\u00a0", (Object)StringEscapeUtils.unescapeXml((String)"&#000160;"), (String)"XML should be able to unescape >0x7f values with three leading 0s");
        Assertions.assertEquals((Object)"ain't", (Object)StringEscapeUtils.unescapeXml((String)"ain&apos;t"));
        Assertions.assertEquals((Object)"ain&apos;t", (Object)StringEscapeUtils.escapeXml((String)"ain't"));
        Assertions.assertEquals((Object)"", (Object)StringEscapeUtils.escapeXml((String)""));
        Assertions.assertNull((Object)StringEscapeUtils.escapeXml(null));
        Assertions.assertNull((Object)StringEscapeUtils.unescapeXml(null));
        StringWriter sw = new StringWriter();
        StringEscapeUtils.ESCAPE_XML.translate((CharSequence)"<abc>", (Writer)sw);
        Assertions.assertEquals((Object)"&lt;abc&gt;", (Object)sw.toString(), (String)"XML was escaped incorrectly");
        sw = new StringWriter();
        StringEscapeUtils.UNESCAPE_XML.translate((CharSequence)"&lt;abc&gt;", (Writer)sw);
        Assertions.assertEquals((Object)"<abc>", (Object)sw.toString(), (String)"XML was unescaped incorrectly");
    }

    @Test
    void testEscapeXml10() {
        Assertions.assertEquals((Object)"a&lt;b&gt;c&quot;d&apos;e&amp;f", (Object)StringEscapeUtils.escapeXml10((String)"a<b>c\"d'e&f"));
        Assertions.assertEquals((Object)"a\tb\rc\nd", (Object)StringEscapeUtils.escapeXml10((String)"a\tb\rc\nd"), (String)"XML 1.0 should not escape \t \n \r");
        Assertions.assertEquals((Object)"ab", (Object)StringEscapeUtils.escapeXml10((String)"a\u0000\u0001\b\u000b\f\u000e\u001fb"), (String)"XML 1.0 should omit most #x0-x8 | #xb | #xc | #xe-#x19");
        Assertions.assertEquals((Object)"a\ud7ff  \ue000b", (Object)StringEscapeUtils.escapeXml10((String)"a\ud7ff\ud800 \udfff \ue000b"), (String)"XML 1.0 should omit #xd800-#xdfff");
        Assertions.assertEquals((Object)"a\ufffdb", (Object)StringEscapeUtils.escapeXml10((String)"a\ufffd\ufffe\uffffb"), (String)"XML 1.0 should omit #xfffe | #xffff");
        Assertions.assertEquals((Object)"a~&#127;&#132;\u0085&#134;&#159;\u00a0b", (Object)StringEscapeUtils.escapeXml10((String)"a~\u007f\u0084\u0085\u0086\u009f\u00a0b"), (String)"XML 1.0 should escape #x7f-#x84 | #x86 - #x9f, for XML 1.1 compatibility");
    }

    @Test
    void testEscapeXml11() {
        Assertions.assertEquals((Object)"a&lt;b&gt;c&quot;d&apos;e&amp;f", (Object)StringEscapeUtils.escapeXml11((String)"a<b>c\"d'e&f"));
        Assertions.assertEquals((Object)"a\tb\rc\nd", (Object)StringEscapeUtils.escapeXml11((String)"a\tb\rc\nd"), (String)"XML 1.1 should not escape \t \n \r");
        Assertions.assertEquals((Object)"ab", (Object)StringEscapeUtils.escapeXml11((String)"a\u0000b"), (String)"XML 1.1 should omit #x0");
        Assertions.assertEquals((Object)"a&#1;&#8;&#11;&#12;&#14;&#31;b", (Object)StringEscapeUtils.escapeXml11((String)"a\u0001\b\u000b\f\u000e\u001fb"), (String)"XML 1.1 should escape #x1-x8 | #xb | #xc | #xe-#x19");
        Assertions.assertEquals((Object)"a~&#127;&#132;\u0085&#134;&#159;\u00a0b", (Object)StringEscapeUtils.escapeXml11((String)"a~\u007f\u0084\u0085\u0086\u009f\u00a0b"), (String)"XML 1.1 should escape #x7F-#x84 | #x86-#x9F");
        Assertions.assertEquals((Object)"a\ud7ff  \ue000b", (Object)StringEscapeUtils.escapeXml11((String)"a\ud7ff\ud800 \udfff \ue000b"), (String)"XML 1.1 should omit #xd800-#xdfff");
        Assertions.assertEquals((Object)"a\ufffdb", (Object)StringEscapeUtils.escapeXml11((String)"a\ufffd\ufffe\uffffb"), (String)"XML 1.1 should omit #xfffe | #xffff");
    }

    @Test
    void testEscapeXmlAllCharacters() {
        CharSequenceTranslator escapeXml = StringEscapeUtils.ESCAPE_XML.with(new CharSequenceTranslator[]{NumericEntityEscaper.below((int)9), NumericEntityEscaper.between((int)11, (int)12), NumericEntityEscaper.between((int)14, (int)25), NumericEntityEscaper.between((int)55296, (int)57343), NumericEntityEscaper.between((int)65534, (int)65535), NumericEntityEscaper.above((int)0x110000)});
        Assertions.assertEquals((Object)"&#0;&#1;&#2;&#3;&#4;&#5;&#6;&#7;&#8;", (Object)escapeXml.translate((CharSequence)"\u0000\u0001\u0002\u0003\u0004\u0005\u0006\u0007\b"));
        Assertions.assertEquals((Object)"\t", (Object)escapeXml.translate((CharSequence)"\t"));
        Assertions.assertEquals((Object)"\n", (Object)escapeXml.translate((CharSequence)"\n"));
        Assertions.assertEquals((Object)"&#11;&#12;", (Object)escapeXml.translate((CharSequence)"\u000b\f"));
        Assertions.assertEquals((Object)"\r", (Object)escapeXml.translate((CharSequence)"\r"));
        Assertions.assertEquals((Object)"Hello World! Ain&apos;t this great?", (Object)escapeXml.translate((CharSequence)"Hello World! Ain't this great?"));
        Assertions.assertEquals((Object)"&#14;&#15;&#24;&#25;", (Object)escapeXml.translate((CharSequence)"\u000e\u000f\u0018\u0019"));
    }

    @Test
    void testEscapeXmlSupplementaryCharacters() {
        CharSequenceTranslator escapeXml = StringEscapeUtils.ESCAPE_XML.with(new CharSequenceTranslator[]{NumericEntityEscaper.between((int)127, (int)Integer.MAX_VALUE)});
        Assertions.assertEquals((Object)"&#144308;", (Object)escapeXml.translate((CharSequence)"\ud84c\udfb4"), (String)"Supplementary character must be represented using a single escape");
        Assertions.assertEquals((Object)"a b c &#144308;", (Object)escapeXml.translate((CharSequence)"a b c \ud84c\udfb4"), (String)"Supplementary characters mixed with basic characters should be encoded correctly");
    }

    @Test
    void testLang313() {
        Assertions.assertEquals((Object)"& &", (Object)StringEscapeUtils.unescapeHtml4((String)"& &amp;"));
    }

    @Test
    void testLang708() throws IOException {
        byte[] inputBytes = Files.readAllBytes(Paths.get("src/test/resources/lang-708-input.txt", new String[0]));
        String input = new String(inputBytes, StandardCharsets.UTF_8);
        String escaped = StringEscapeUtils.escapeEcmaScript((String)input);
        Assertions.assertTrue((boolean)escaped.endsWith("}]"), (String)escaped);
        Assertions.assertTrue((boolean)escaped.endsWith("\"valueCode\\\":\\\"\\\"}]"), (String)escaped);
    }

    @Test
    void testLang720() {
        String input = "\ud842\udfb7A";
        String escaped = StringEscapeUtils.escapeXml((String)"\ud842\udfb7A");
        Assertions.assertEquals((Object)"\ud842\udfb7A", (Object)escaped);
    }

    @Test
    void testLang911() {
        String bellsTest = "\ud83d\udc80\ud83d\udd14";
        String value = StringEscapeUtils.escapeJava((String)"\ud83d\udc80\ud83d\udd14");
        String valueTest = StringEscapeUtils.unescapeJava((String)value);
        Assertions.assertEquals((Object)"\ud83d\udc80\ud83d\udd14", (Object)valueTest);
    }

    @Test
    void testStandaloneAmphersand() {
        Assertions.assertEquals((Object)"<P&O>", (Object)StringEscapeUtils.unescapeHtml4((String)"&lt;P&O&gt;"));
        Assertions.assertEquals((Object)"test & <", (Object)StringEscapeUtils.unescapeHtml4((String)"test & &lt;"));
        Assertions.assertEquals((Object)"<P&O>", (Object)StringEscapeUtils.unescapeXml((String)"&lt;P&O&gt;"));
        Assertions.assertEquals((Object)"test & <", (Object)StringEscapeUtils.unescapeXml((String)"test & &lt;"));
    }

    @Test
    void testUnescapeCsvIllegalStateException() {
        StringWriter writer = new StringWriter();
        Assertions.assertThrows(IllegalStateException.class, () -> StringEscapeUtils.UNESCAPE_CSV.translate((CharSequence)FOO, -1, (Writer)writer));
    }

    @Test
    void testUnescapeCsvString() {
        Assertions.assertEquals((Object)"foo.bar", (Object)StringEscapeUtils.unescapeCsv((String)"foo.bar"));
        Assertions.assertEquals((Object)"foo,bar", (Object)StringEscapeUtils.unescapeCsv((String)"\"foo,bar\""));
        Assertions.assertEquals((Object)"foo\nbar", (Object)StringEscapeUtils.unescapeCsv((String)"\"foo\nbar\""));
        Assertions.assertEquals((Object)"foo\rbar", (Object)StringEscapeUtils.unescapeCsv((String)"\"foo\rbar\""));
        Assertions.assertEquals((Object)"foo\"bar", (Object)StringEscapeUtils.unescapeCsv((String)"\"foo\"\"bar\""));
        Assertions.assertEquals((Object)"foo\ud84c\udfb4bar", (Object)StringEscapeUtils.unescapeCsv((String)"foo\ud84c\udfb4bar"));
        Assertions.assertEquals((Object)"", (Object)StringEscapeUtils.unescapeCsv((String)""));
        Assertions.assertNull((Object)StringEscapeUtils.unescapeCsv(null));
        Assertions.assertEquals((Object)"\"foo.bar\"", (Object)StringEscapeUtils.unescapeCsv((String)"\"foo.bar\""));
    }

    @Test
    void testUnescapeCsvWriter() throws Exception {
        this.checkCsvUnescapeWriter("foo.bar", "foo.bar");
        this.checkCsvUnescapeWriter("foo,bar", "\"foo,bar\"");
        this.checkCsvUnescapeWriter("foo\nbar", "\"foo\nbar\"");
        this.checkCsvUnescapeWriter("foo\rbar", "\"foo\rbar\"");
        this.checkCsvUnescapeWriter("foo\"bar", "\"foo\"\"bar\"");
        this.checkCsvUnescapeWriter("foo\ud84c\udfb4bar", "foo\ud84c\udfb4bar");
        this.checkCsvUnescapeWriter("", null);
        this.checkCsvUnescapeWriter("", "");
        this.checkCsvUnescapeWriter("\"foo.bar\"", "\"foo.bar\"");
    }

    @Test
    void testUnescapeEcmaScript() {
        Assertions.assertNull((Object)StringEscapeUtils.escapeEcmaScript(null));
        LangAssertions.assertNullPointerException(() -> StringEscapeUtils.UNESCAPE_ECMASCRIPT.translate(null, null));
        LangAssertions.assertNullPointerException(() -> StringEscapeUtils.UNESCAPE_ECMASCRIPT.translate((CharSequence)"", null));
        Assertions.assertEquals((Object)"He didn't say, \"stop!\"", (Object)StringEscapeUtils.unescapeEcmaScript((String)"He didn\\'t say, \\\"stop!\\\""));
        Assertions.assertEquals((Object)"document.getElementById(\"test\").value = '<script>alert('aaa');</script>';", (Object)StringEscapeUtils.unescapeEcmaScript((String)"document.getElementById(\\\"test\\\").value = \\'<script>alert(\\'aaa\\');<\\/script>\\';"));
    }

    @Test
    void testUnescapeHexCharsHtml() {
        Assertions.assertEquals((Object)"\u0080\u009f", (Object)StringEscapeUtils.unescapeHtml4((String)"&#x80;&#x9F;"), (String)"hex number unescape");
        Assertions.assertEquals((Object)"\u0080\u009f", (Object)StringEscapeUtils.unescapeHtml4((String)"&#X80;&#X9F;"), (String)"hex number unescape");
        for (char i = '\u0000'; i < '\uffff'; i = (char)(i + '\u0001')) {
            Character c1 = Character.valueOf(i);
            Character c2 = Character.valueOf((char)(i + '\u0001'));
            String expected = c1.toString() + c2;
            String escapedC1 = "&#x" + Integer.toHexString(c1.charValue()) + ";";
            String escapedC2 = "&#x" + Integer.toHexString(c2.charValue()) + ";";
            Assertions.assertEquals((Object)expected, (Object)StringEscapeUtils.unescapeHtml4((String)(escapedC1 + escapedC2)), (String)("hex number unescape index " + i));
        }
    }

    @Test
    void testUnescapeHtml4() throws IOException {
        for (String[] element : HTML_ESCAPES) {
            String message = element[0];
            String expected = element[2];
            String original = element[1];
            Assertions.assertEquals((Object)expected, (Object)StringEscapeUtils.unescapeHtml4((String)original), (String)message);
            StringWriter sw = new StringWriter();
            StringEscapeUtils.UNESCAPE_HTML4.translate((CharSequence)original, (Writer)sw);
            String actual = original == null ? null : sw.toString();
            Assertions.assertEquals((Object)expected, (Object)actual, (String)message);
        }
        Assertions.assertEquals((Object)"Fran\u00e7ais", (Object)StringEscapeUtils.unescapeHtml4((String)"Fran\u00e7ais"), (String)"funny chars pass through OK");
        Assertions.assertEquals((Object)"Hello&;World", (Object)StringEscapeUtils.unescapeHtml4((String)"Hello&;World"));
        Assertions.assertEquals((Object)"Hello&#;World", (Object)StringEscapeUtils.unescapeHtml4((String)"Hello&#;World"));
        Assertions.assertEquals((Object)"Hello&# ;World", (Object)StringEscapeUtils.unescapeHtml4((String)"Hello&# ;World"));
        Assertions.assertEquals((Object)"Hello&##;World", (Object)StringEscapeUtils.unescapeHtml4((String)"Hello&##;World"));
    }

    @Test
    void testUnescapeJava() throws IOException {
        Assertions.assertNull((Object)StringEscapeUtils.unescapeJava(null));
        LangAssertions.assertNullPointerException(() -> StringEscapeUtils.UNESCAPE_JAVA.translate(null, null));
        LangAssertions.assertNullPointerException(() -> StringEscapeUtils.UNESCAPE_JAVA.translate((CharSequence)"", null));
        Assertions.assertThrows(RuntimeException.class, () -> StringEscapeUtils.unescapeJava((String)"\\u02-3"));
        this.assertUnescapeJava("", "");
        this.assertUnescapeJava("test", "test");
        this.assertUnescapeJava("\ntest\b", "\\ntest\\b");
        this.assertUnescapeJava("\u123425foo\ntest\b", "\\u123425foo\\ntest\\b");
        this.assertUnescapeJava("'\foo\teste\r", "\\'\\foo\\teste\\r");
        this.assertUnescapeJava("", "\\");
        this.assertUnescapeJava("lowercase Unicode", "\uabcdx", "\\uabcdx");
        this.assertUnescapeJava("uppercase Unicode", "\uabcdx", "\\uABCDx");
        this.assertUnescapeJava("Unicode as final character", "\uabcd", "\\uabcd");
    }

    @Test
    void testUnescapeJson() {
        Assertions.assertNull((Object)StringEscapeUtils.unescapeJson(null));
        LangAssertions.assertNullPointerException(() -> StringEscapeUtils.UNESCAPE_JSON.translate(null, null));
        LangAssertions.assertNullPointerException(() -> StringEscapeUtils.UNESCAPE_JSON.translate((CharSequence)"", null));
        Assertions.assertEquals((Object)"He didn't say, \"stop!\"", (Object)StringEscapeUtils.unescapeJson((String)"He didn't say, \\\"stop!\\\""));
        String expected = "\"foo\" isn't \"bar\". specials: \b\r\n\f\t\\/";
        String input = "\\\"foo\\\" isn't \\\"bar\\\". specials: \\b\\r\\n\\f\\t\\\\\\/";
        Assertions.assertEquals((Object)"\"foo\" isn't \"bar\". specials: \b\r\n\f\t\\/", (Object)StringEscapeUtils.unescapeJson((String)"\\\"foo\\\" isn't \\\"bar\\\". specials: \\b\\r\\n\\f\\t\\\\\\/"));
    }

    @Test
    void testUnescapeUnknownEntity() {
        Assertions.assertEquals((Object)"&zzzz;", (Object)StringEscapeUtils.unescapeHtml4((String)"&zzzz;"));
    }

    @Test
    void testUnescapeXmlSupplementaryCharacters() {
        Assertions.assertEquals((Object)"\ud84c\udfb4", (Object)StringEscapeUtils.unescapeXml((String)"&#144308;"), (String)"Supplementary character must be represented using a single escape");
        Assertions.assertEquals((Object)"a b c \ud84c\udfb4", (Object)StringEscapeUtils.unescapeXml((String)"a b c &#144308;"), (String)"Supplementary characters mixed with basic characters should be decoded correctly");
    }
}

