/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.access.sqlbuilder.sqltree;

import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.cayenne.access.sqlbuilder.sqltree.ChildProcessor;
import org.apache.cayenne.access.sqlbuilder.sqltree.Node;
import org.apache.cayenne.map.DbAttribute;

public class PerAttributeChildProcessor<T extends Node>
implements ChildProcessor<T> {
    private final Map<DbAttribute, ChildProcessor<T>> processorByAttribute = new ConcurrentHashMap<DbAttribute, ChildProcessor<T>>();
    private final Function<T, DbAttribute> attributeMapper;
    private final Function<DbAttribute, ChildProcessor<T>> processorFactory;

    public PerAttributeChildProcessor(Function<T, DbAttribute> attributeMapper, Function<DbAttribute, ChildProcessor<T>> processorFactory) {
        this.processorFactory = processorFactory;
        this.attributeMapper = attributeMapper;
    }

    @Override
    public Optional<Node> process(Node parent, T child, int index) {
        DbAttribute dbAttribute = this.attributeMapper.apply(child);
        if (dbAttribute == null) {
            return this.processorFactory.apply(null).process(parent, child, index);
        }
        return this.processorByAttribute.computeIfAbsent(dbAttribute, this.processorFactory).process(parent, child, index);
    }
}

