/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.cayenne.CayenneRuntimeException;
import org.apache.cayenne.QueryResult;
import org.apache.cayenne.QueryResultItem;
import org.apache.cayenne.util.GenericQueryResult;

public class QueryResultBuilder {
    protected List<QueryResultItem> queryResult;

    public static QueryResultBuilder builder() {
        return new QueryResultBuilder(3);
    }

    public static QueryResultBuilder builder(int expectedSize) {
        return new QueryResultBuilder(expectedSize);
    }

    public static QueryResult empty() {
        return new GenericQueryResult(Collections.emptyList());
    }

    public static QueryResult singleSelect(List<?> selectResult) {
        return new GenericQueryResult(Collections.singletonList(new SelectResult(selectResult)));
    }

    public static QueryResult singleObjectSelect(Object selectObject) {
        List<Object> result = Collections.singletonList(selectObject);
        return new GenericQueryResult(Collections.singletonList(new SelectResult<Object>(result)));
    }

    QueryResultBuilder(int expectedSize) {
        this.queryResult = new ArrayList<QueryResultItem>(expectedSize);
    }

    public QueryResultBuilder addSelectResult(List<?> result) {
        this.queryResult.add(new SelectResult(result));
        return this;
    }

    public QueryResultBuilder addBatchUpdateResult(int[] result) {
        this.queryResult.add(new BatchUpdateResult(result));
        return this;
    }

    public QueryResult build() {
        return new GenericQueryResult(this.queryResult);
    }

    private static class SelectResult<T>
    implements QueryResultItem<T> {
        private List<T> result;

        SelectResult(List<T> result) {
            this.result = result;
        }

        @Override
        public boolean isSelectResult() {
            return true;
        }

        @Override
        public boolean isBatchUpdate() {
            return false;
        }

        @Override
        public List<T> getSelectResult() {
            return this.result;
        }

        @Override
        public int getUpdateCount() {
            throw new CayenneRuntimeException("Can't access update result. This result is a select", new Object[0]);
        }

        @Override
        public int[] getBatchUpdateCounts() {
            throw new CayenneRuntimeException("Can't access update result. This result is a select", new Object[0]);
        }
    }

    private static class BatchUpdateResult
    implements QueryResultItem {
        private int[] result;

        BatchUpdateResult(int[] result) {
            this.result = result;
        }

        @Override
        public boolean isSelectResult() {
            return false;
        }

        @Override
        public boolean isBatchUpdate() {
            return this.result.length > 1;
        }

        public List<?> getSelectResult() {
            throw new CayenneRuntimeException("Can't access select result. This result is an update", new Object[0]);
        }

        @Override
        public int getUpdateCount() {
            if (this.result.length == 0) {
                throw new CayenneRuntimeException("No update results", new Object[0]);
            }
            if (this.result.length == 1) {
                return this.result[0];
            }
            throw new CayenneRuntimeException("This result is a batch update", new Object[0]);
        }

        @Override
        public int[] getBatchUpdateCounts() {
            return this.result;
        }
    }
}

