/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cayenne.modeler.util.combo;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.CellRendererPane;
import javax.swing.InputMap;
import javax.swing.JComboBox;
import javax.swing.JList;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;

public class EditorTextField
extends JTextField
implements FocusListener {
    protected JComboBox combo;
    private final CellRendererPane rendererPane;
    private final JList list = new JList();
    private boolean hasFocus;

    public EditorTextField(JComboBox edited) {
        this.combo = edited;
        this.rendererPane = new CellRendererPane();
        this.addFocusListener(this);
        this.initTabHandler();
    }

    private void initTabHandler() {
        this.combo.setFocusTraversalKeysEnabled(false);
        this.combo.getActionMap().put("tab-action", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                EditorTextField.this.combo.setSelectedItem(EditorTextField.this.getText());
                Container component = EditorTextField.this.getParent().getParent();
                if (component instanceof JTable) {
                    JTable table = (JTable)component;
                    if ((e.getModifiers() & 1) > 0) {
                        table.changeSelection(table.getEditingRow(), table.getEditingColumn() - 1, false, false);
                    } else {
                        table.changeSelection(table.getEditingRow(), table.getEditingColumn() + 1, false, false);
                    }
                } else if ((e.getModifiers() & 1) > 0) {
                    EditorTextField.this.transferFocusBackward();
                } else {
                    EditorTextField.this.transferFocus();
                }
            }
        });
        InputMap inputMap = this.combo.getInputMap(1);
        inputMap.put(KeyStroke.getKeyStroke("TAB"), "tab-action");
        inputMap.put(KeyStroke.getKeyStroke("shift TAB"), "tab-action");
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.hasFocus) {
            super.paintComponent(g);
        } else {
            this.list.setEnabled(this.combo.isEnabled());
            Component c = this.combo.getRenderer().getListCellRendererComponent(this.list, this.combo.getSelectedItem(), -1, false, false);
            Insets insets = this.getInsets();
            Color oldColor = g.getColor();
            g.setColor(this.getBackground());
            if (Boolean.TRUE.equals(this.getClientProperty("TextField.fullSizeBackground"))) {
                g.fillRect(0, 0, this.getWidth(), this.getHeight());
            } else {
                g.fillRect(insets.left, insets.top, this.getWidth() - insets.right - insets.left, this.getHeight() - insets.bottom - insets.top);
            }
            g.setColor(oldColor);
            this.rendererPane.paintComponent(g, c, this.combo, insets.left, insets.top, this.getWidth() - insets.right - insets.left, this.getHeight() - insets.bottom - insets.top);
        }
    }

    @Override
    public void focusGained(FocusEvent e) {
        this.hasFocus = true;
        this.combo.repaint();
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.hasFocus = false;
        this.combo.repaint();
    }
}

