/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.model;

import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.util.List;
import org.apache.camel.Predicate;
import org.apache.camel.model.OnWhenDefinition;
import org.apache.camel.model.OutputDefinition;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.spi.AsPredicate;
import org.apache.camel.spi.Metadata;

@Metadata(label="configuration")
@XmlRootElement(name="intercept")
@XmlAccessorType(value=XmlAccessType.FIELD)
public class InterceptDefinition
extends OutputDefinition<InterceptDefinition> {
    @Metadata(description="To use an expression to only trigger intercepting in specific situations")
    @XmlElement
    @AsPredicate
    private OnWhenDefinition onWhen;

    public InterceptDefinition() {
    }

    protected InterceptDefinition(InterceptDefinition source) {
        super(source);
        this.onWhen = source.onWhen != null ? source.onWhen.copyDefinition() : null;
    }

    @Override
    public InterceptDefinition copyDefinition() {
        return new InterceptDefinition(this);
    }

    @Override
    public String toString() {
        return "Intercept[" + String.valueOf(this.getOutputs()) + "]";
    }

    @Override
    public String getShortName() {
        return "intercept";
    }

    @Override
    public String getLabel() {
        return "intercept";
    }

    @Override
    public boolean isAbstract() {
        return true;
    }

    @Override
    public boolean isTopLevelOnly() {
        return true;
    }

    @Override
    public List<ProcessorDefinition<?>> getOutputs() {
        return this.outputs;
    }

    @Override
    @XmlElementRef
    public void setOutputs(List<ProcessorDefinition<?>> outputs) {
        super.setOutputs(outputs);
    }

    public OnWhenDefinition getOnWhen() {
        return this.onWhen;
    }

    public void setOnWhen(OnWhenDefinition onWhen) {
        this.onWhen = onWhen;
    }

    @Deprecated
    public InterceptDefinition when(@AsPredicate Predicate predicate) {
        return this.onWhen(predicate);
    }

    public InterceptDefinition onWhen(@AsPredicate Predicate predicate) {
        this.setOnWhen(new OnWhenDefinition(predicate));
        return this;
    }
}

